/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.orient.internal.hosted;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.RPackagesBuilderFacet;
import com.sonatype.nexus.repository.r.internal.hosted.RMetadataInvalidationEvent;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import com.sonatype.nexus.repository.r.orient.OrientRHostedFacet;
import com.sonatype.nexus.repository.r.orient.util.OrientRFacetUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientRPackagesBuilderFacetImpl
extends FacetSupport
implements RPackagesBuilderFacet,
EventAware.Asynchronous {
    private final EventManager eventManager;
    private final long interval;
    private boolean waiting;

    @Inject
    public OrientRPackagesBuilderFacetImpl(EventManager eventManager, @Named(value="${nexus.r.packagesBuilder.interval:-1000}") long interval) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.interval = interval;
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetEvent event) {
        if (this.shouldInvalidate(event)) {
            this.invalidateMetadata(RPathUtils.getBasePath(event.getAsset().name()));
        }
    }

    @Override
    public void invalidateMetadata(String basePath) {
        if (!this.waiting) {
            this.eventManager.post((Object)new RMetadataInvalidationEvent(this.getRepository().getName(), basePath));
        }
    }

    @Subscribe
    public void on(RMetadataInvalidationEvent event) {
        if (this.getRepository().getName().equals(event.getRepositoryName())) {
            try {
                this.waiting = true;
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("R invalidation thread interrupted on repository {}, proceeding with invalidation", (Object)this.getRepository().getName());
                Thread.currentThread().interrupt();
            }
            this.waiting = false;
            this.log.info("Rebuilding R PACKAGES.gz metadata for repository {}", (Object)this.getRepository().getName());
            UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
            try {
                try {
                    OrientRHostedFacet hostedFacet = (OrientRHostedFacet)this.getRepository().facet(OrientRHostedFacet.class);
                    hostedFacet.buildAndPutPackagesGz(event.getBasePath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            finally {
                UnitOfWork.end();
            }
        }
    }

    private boolean shouldInvalidate(AssetEvent assetEvent) {
        return assetEvent.isLocal() && this.getRepository().getName().equals(assetEvent.getRepositoryName()) && this.isArchiveAssetKind(assetEvent.getAsset());
    }

    private boolean isArchiveAssetKind(Asset asset) {
        return AssetKind.ARCHIVE == OrientRFacetUtils.extractAssetKind(asset);
    }
}

