/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.orient.internal.hosted;

import com.sonatype.nexus.repository.r.internal.util.PackageValidator;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import com.sonatype.nexus.repository.r.orient.OrientRHostedFacet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public final class OrientHostedHandlers
extends ComponentSupport {
    final Handler getPackages = context -> {
        String path = RPathUtils.extractRequestPath(context);
        OrientRHostedFacet hostedFacet = (OrientRHostedFacet)context.getRepository().facet(OrientRHostedFacet.class);
        Content content = hostedFacet.getStoredContent(path);
        if (content != null || (content = hostedFacet.buildAndPutPackagesGz(RPathUtils.getBasePath(path))) != null) {
            return HttpResponses.ok((Payload)content);
        }
        return HttpResponses.notFound();
    };
    final Handler getArchive = context -> {
        String path = RPathUtils.extractRequestPath(context);
        Content content = ((OrientRHostedFacet)context.getRepository().facet(OrientRHostedFacet.class)).getStoredContent(path);
        if (content != null) {
            return HttpResponses.ok((Payload)content);
        }
        return HttpResponses.notFound();
    };
    final Handler putArchive = context -> {
        String path = RPathUtils.extractRequestPath(context);
        try {
            PackageValidator.validateArchiveUploadPath(path);
        }
        catch (ValidationErrorsException e) {
            return HttpResponses.badRequest((String)e.getMessage());
        }
        ((OrientRHostedFacet)context.getRepository().facet(OrientRHostedFacet.class)).upload(path, context.getRequest().getPayload());
        return HttpResponses.ok();
    };
}

