/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.internal.util;

import com.sonatype.nexus.repository.r.AssetKind;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.view.Context;

public final class RPathUtils {
    public static final Pattern PATTERN_PACKAGES_EXTENSION = Pattern.compile(".*PACKAGES.*");
    public static final Pattern PATTERN_METADATA_RDS_EXTENSION = Pattern.compile(".+.rds");
    public static final Pattern PATTERN_ARCHIVE_EXTENSION = Pattern.compile(".+(.zip|.tgz|.tar.gz)");
    public static final Pattern PATTERN_PATH = Pattern.compile(".+/.+/.+");
    public static final String PACKAGES_GZ_FILENAME = "PACKAGES.gz";

    public static String buildPath(String path, String filename) {
        return String.valueOf(StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0])) + filename;
    }

    public static String extractRequestPath(Context context) {
        return RPathUtils.removeInitialSlashFromPath(context.getRequest().getPath());
    }

    public static String removeInitialSlashFromPath(String path) {
        return StringUtils.stripStart((String)path, (String)"/");
    }

    public static String getBasePath(String path) {
        int pathEndCharIndex = StringUtils.stripEnd((String)path, (String)"/").lastIndexOf(47);
        return path.substring(0, pathEndCharIndex);
    }

    public static AssetKind getAssetKind(String path) {
        AssetKind assetKind = AssetKind.ARCHIVE;
        if (PATTERN_PACKAGES_EXTENSION.matcher(path).matches()) {
            assetKind = AssetKind.PACKAGES;
        } else if (PATTERN_METADATA_RDS_EXTENSION.matcher(path).matches()) {
            assetKind = AssetKind.RDS_METADATA;
        }
        return assetKind;
    }

    public static boolean isValidArchiveExtension(String nameWithExtension) {
        return PATTERN_ARCHIVE_EXTENSION.matcher(nameWithExtension).matches();
    }

    public static boolean isValidRepoPath(String path) {
        return PATTERN_PATH.matcher(path).matches();
    }

    private RPathUtils() {
    }
}

