/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.internal.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.r.internal.RException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.sonatype.nexus.common.hash.HashAlgorithm;

public final class RMetadataUtils {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA1);

    public static Map<String, String> parseDescriptionFile(InputStream in) {
        Preconditions.checkNotNull((Object)in);
        try {
            LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
            InternetHeaders headers = new InternetHeaders(in);
            Enumeration headerEnumeration = headers.getAllHeaders();
            while (headerEnumeration.hasMoreElements()) {
                Header header = (Header)headerEnumeration.nextElement();
                String name = header.getName();
                String value = header.getValue().replace("\r\n", "\n").replace("\r", "\n");
                results.put(name, value);
            }
            return results;
        }
        catch (MessagingException e) {
            throw new RException(null, e);
        }
    }

    private RMetadataUtils() {
    }
}

