/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.internal.util;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.r.internal.RException;
import com.sonatype.nexus.repository.r.internal.util.RMetadataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.sonatype.nexus.common.io.InputStreamSupplier;

public final class RDescriptionUtils {
    private static final Pattern DESCRIPTION_FILE_PATTERN = Pattern.compile("^[^/]*/DESCRIPTION$");

    public static Map<String, String> extractDescriptionFromArchive(String filename, InputStreamSupplier inputStreamSupplier) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = inputStreamSupplier.get();){
                Preconditions.checkNotNull((Object)filename);
                Preconditions.checkNotNull((Object)is);
                String lowerCaseFilename = filename.toLowerCase();
                if (lowerCaseFilename.endsWith(".tar.gz") || lowerCaseFilename.endsWith(".tgz")) {
                    return RDescriptionUtils.extractMetadataFromTgz(is);
                }
                if (lowerCaseFilename.endsWith(".gz")) {
                    return RDescriptionUtils.extractMetadataFromGz(is);
                }
                if (lowerCaseFilename.endsWith(".zip")) {
                    return RDescriptionUtils.extractMetadataFromZip(is);
                }
                throw new IllegalStateException("Unexpected file extension for file: " + filename);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public static Map<String, String> extractDescriptionFromArchive(String filename, InputStream is) {
        return RDescriptionUtils.extractDescriptionFromArchive(filename, () -> is);
    }

    private static Map<String, String> extractMetadataFromTgz(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        try {
            CompressorStreamFactory compressorStreamFactory = new CompressorStreamFactory();
            Throwable throwable = null;
            Object var3_5 = null;
            try (CompressorInputStream cis = compressorStreamFactory.createCompressorInputStream("gz", is);){
                return RDescriptionUtils.extractMetadataFromArchive("tar", (InputStream)cis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CompressorException e) {
            throw new RException(null, e);
        }
    }

    private static Map<String, String> extractMetadataFromGz(InputStream in) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (GZIPInputStream gz = new GZIPInputStream(in);){
                return RMetadataUtils.parseDescriptionFile(gz);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RException(null, e);
        }
    }

    private static Map<String, String> extractMetadataFromZip(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        return RDescriptionUtils.extractMetadataFromArchive("zip", is);
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, String> extractMetadataFromArchive(String archiveType, InputStream is) {
        archiveFactory = new ArchiveStreamFactory();
        try {
            var3_3 = null;
            var4_6 = null;
            try {
                ais = archiveFactory.createArchiveInputStream(archiveType, is);
                try {
                    entry = ais.getNextEntry();
                    while (true) {
                        if (!entry.isDirectory() && RDescriptionUtils.DESCRIPTION_FILE_PATTERN.matcher(entry.getName()).matches()) {
                            return RMetadataUtils.parseDescriptionFile((InputStream)ais);
                        }
                        entry = ais.getNextEntry();
                        return entry;
                    }
                }
                finally {
                    if (entry != null) ** continue;
                }
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                } else if (var3_3 != var4_7) {
                    var3_3.addSuppressed(var4_7);
                }
                throw var3_3;
            }
        }
        catch (IOException | ArchiveException e) {
            throw new RException(null, e);
        }
        throw new IllegalStateException("No metadata file found");
    }

    private RDescriptionUtils() {
    }
}

