/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.internal.util;

import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import org.sonatype.nexus.rest.ValidationErrorsException;

public final class PackageValidator {
    public static final String NOT_VALID_PATH_ERROR_MESSAGE = "Provided path is not valid and is expecting src/contrib or bin/<os>/contrib/<R_version>";
    public static final String NOT_VALID_EXTENSION_ERROR_MESSAGE = "Provided extension is not .zip, .tar.gz or .tgz";

    private PackageValidator() {
    }

    public static void validateArchiveUploadPath(String fullPath) {
        if (!RPathUtils.isValidRepoPath(fullPath)) {
            throw new ValidationErrorsException(NOT_VALID_PATH_ERROR_MESSAGE);
        }
        if (!RPathUtils.isValidArchiveExtension(fullPath)) {
            throw new ValidationErrorsException(NOT_VALID_EXTENSION_ERROR_MESSAGE);
        }
    }
}

