/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal.hosted;

import com.sonatype.nexus.repository.r.internal.hosted.RPackageVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.sonatype.nexus.common.collect.NestedAttributesMap;

public class RPackagesBuilder {
    private final Map<String, RPackageVersion> packageVersions = new HashMap<String, RPackageVersion>();
    private final Map<String, Map<String, String>> packageInformation = new TreeMap<String, Map<String, String>>();

    public Map<String, Map<String, String>> getPackageInformation() {
        return Collections.unmodifiableMap(this.packageInformation);
    }

    public void append(NestedAttributesMap formatAttributes) {
        String packageName = (String)formatAttributes.get("Package", String.class);
        RPackageVersion oldVersion = this.packageVersions.get(packageName);
        RPackageVersion newVersion = new RPackageVersion((String)formatAttributes.get("Version", String.class));
        if (oldVersion == null || newVersion.compareTo(oldVersion) > 0) {
            HashMap<String, String> newInformation = new HashMap<String, String>();
            newInformation.put("Package", (String)formatAttributes.get("Package", String.class));
            newInformation.put("Version", (String)formatAttributes.get("Version", String.class));
            newInformation.put("Depends", (String)formatAttributes.get("Depends", String.class));
            newInformation.put("Imports", (String)formatAttributes.get("Imports", String.class));
            newInformation.put("Suggests", (String)formatAttributes.get("Suggests", String.class));
            newInformation.put("LinkingTo", (String)formatAttributes.get("LinkingTo", String.class));
            newInformation.put("License", (String)formatAttributes.get("License", String.class));
            newInformation.put("NeedsCompilation", (String)formatAttributes.get("NeedsCompilation", String.class));
            this.packageVersions.put(packageName, newVersion);
            this.packageInformation.put(packageName, newInformation);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] buildPackagesGz() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                CompressorStreamFactory compressorStreamFactory = new CompressorStreamFactory();
                Throwable throwable2 = null;
                Object var6_10 = null;
                try {
                    CompressorOutputStream cos = compressorStreamFactory.createCompressorOutputStream("gz", (OutputStream)os);
                    try {
                        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)cos, StandardCharsets.UTF_8);){
                            for (Map.Entry<String, Map<String, String>> eachPackage : this.packageInformation.entrySet()) {
                                this.writePackageInfo(writer, eachPackage.getValue());
                            }
                        }
                        if (cos == null) return os.toByteArray();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (cos == null) throw throwable2;
                        cos.close();
                        throw throwable2;
                    }
                    cos.close();
                    return os.toByteArray();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    } else {
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (CompressorException e) {
            throw new IOException("Error compressing metadata", e);
        }
    }

    private void writePackageInfo(OutputStreamWriter writer, Map<String, String> packageInfo) throws IOException {
        InternetHeaders headers = new InternetHeaders();
        headers.addHeader("Package", packageInfo.get("Package"));
        headers.addHeader("Version", packageInfo.get("Version"));
        headers.addHeader("Depends", packageInfo.get("Depends"));
        headers.addHeader("Imports", packageInfo.get("Imports"));
        headers.addHeader("Suggests", packageInfo.get("Suggests"));
        headers.addHeader("LinkingTo", packageInfo.get("LinkingTo"));
        headers.addHeader("License", packageInfo.get("License"));
        headers.addHeader("NeedsCompilation", packageInfo.get("NeedsCompilation"));
        Enumeration headerLines = headers.getAllHeaderLines();
        while (headerLines.hasMoreElements()) {
            String line = (String)headerLines.nextElement();
            writer.write(line, 0, line.length());
            writer.write(10);
        }
        writer.write(10);
    }
}

