/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal.hosted;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.RPackagesBuilderFacet;
import com.sonatype.nexus.repository.r.datastore.RContentFacet;
import com.sonatype.nexus.repository.r.datastore.internal.hosted.RPackagesBuilder;
import com.sonatype.nexus.repository.r.internal.hosted.RMetadataInvalidationEvent;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Facet.Exposed
@Named
public class RHostedMetadataFacet
extends FacetSupport
implements RPackagesBuilderFacet,
EventAware.Asynchronous {
    private final long interval;
    private final AtomicBoolean waiting = new AtomicBoolean(false);

    @Inject
    public RHostedMetadataFacet(@Named(value="${nexus.r.packagesBuilder.interval:-1000}") long interval) {
        this.interval = interval;
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetEvent event) {
        if (this.shouldInvalidate(event)) {
            String basePath = RPathUtils.getBasePath(event.getAsset().path());
            this.invalidateMetadata(basePath);
        }
    }

    private boolean shouldInvalidate(AssetEvent event) {
        Optional eventRepositoryOptional = event.getRepository();
        if (!eventRepositoryOptional.isPresent()) {
            return false;
        }
        Repository eventRepository = (Repository)eventRepositoryOptional.get();
        return this.getRepository().getName().equals(eventRepository.getName()) && event.getAsset().kind().equals(AssetKind.ARCHIVE.name());
    }

    @Override
    public void invalidateMetadata(String basePath) {
        if (!this.waiting.get()) {
            this.getEventManager().post((Object)new RMetadataInvalidationEvent(this.getRepository().getName(), basePath));
        }
    }

    @Subscribe
    public void on(RMetadataInvalidationEvent event) throws IOException {
        if (this.getRepository().getName().equals(event.getRepositoryName())) {
            block6: {
                try {
                    try {
                        this.waiting.set(true);
                        Thread.sleep(this.interval);
                    }
                    catch (InterruptedException interruptedException) {
                        this.log.warn("R invalidation thread interrupted on repository {}, proceeding with invalidation", (Object)this.getRepository().getName());
                        Thread.currentThread().interrupt();
                        this.waiting.set(false);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.waiting.set(false);
                    throw throwable;
                }
                this.waiting.set(false);
            }
            this.log.info("Rebuilding R PACKAGES.gz metadata for repository {}", (Object)this.getRepository().getName());
            this.recalculatePackagesGz(event.getBasePath());
        }
    }

    private FluentAsset recalculatePackagesGz(String basePath) throws IOException {
        RContentFacet contentFacet = (RContentFacet)this.facet(RContentFacet.class);
        RPackagesBuilder builder = new RPackagesBuilder();
        for (FluentAsset fluentAsset : contentFacet.getAssetsByKind(AssetKind.ARCHIVE.name())) {
            String assetBasePath = RPathUtils.getBasePath(fluentAsset.path());
            if (!assetBasePath.equals(basePath)) continue;
            NestedAttributesMap formatAttributes = fluentAsset.attributes("r");
            builder.append(formatAttributes);
        }
        byte[] bytes = builder.buildPackagesGz();
        BytesPayload payload = new BytesPayload(bytes, null);
        String assetPath = RPathUtils.buildPath(basePath, "PACKAGES.gz");
        return contentFacet.putMetadata((Payload)payload, assetPath, AssetKind.PACKAGES);
    }

    public FluentAsset getOrCreatePackagesGz(String assetPath) throws IOException {
        Optional<FluentAsset> asset = ((RContentFacet)this.facet(RContentFacet.class)).getAsset(assetPath);
        if (asset.isPresent()) {
            return asset.get();
        }
        String basePath = RPathUtils.getBasePath(assetPath);
        return this.recalculatePackagesGz(basePath);
    }
}

