/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal.hosted;

import com.sonatype.nexus.repository.r.datastore.RContentFacet;
import com.sonatype.nexus.repository.r.datastore.internal.hosted.RHostedMetadataFacet;
import com.sonatype.nexus.repository.r.internal.util.PackageValidator;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class RHostedHandlers {
    public Handler getPackages = context -> {
        String assetPath = RPathUtils.extractRequestPath(context);
        FluentAsset fluentAsset = ((RHostedMetadataFacet)context.getRepository().facet(RHostedMetadataFacet.class)).getOrCreatePackagesGz(assetPath);
        return HttpResponses.ok((Payload)fluentAsset.download());
    };
    public Handler getArchive = context -> {
        String assetPath = RPathUtils.extractRequestPath(context);
        Optional<FluentAsset> fluentAsset = ((RContentFacet)context.getRepository().facet(RContentFacet.class)).getAsset(assetPath);
        if (fluentAsset.isPresent()) {
            return HttpResponses.ok((Payload)fluentAsset.get().download());
        }
        return HttpResponses.notFound();
    };
    public Handler putArchive = context -> {
        String path = RPathUtils.extractRequestPath(context);
        try {
            PackageValidator.validateArchiveUploadPath(path);
        }
        catch (ValidationErrorsException e) {
            return HttpResponses.badRequest((String)e.getMessage());
        }
        Payload payload = context.getRequest().getPayload();
        ((RContentFacet)context.getRepository().facet(RContentFacet.class)).putPackage(payload, path);
        return HttpResponses.ok();
    };
}

