/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal.browse;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.browse.node.BrowsePathBuilder;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.DefaultBrowseNodeGenerator;

@Singleton
@Named(value="r")
public class RBrowseNodeGenerator
extends DefaultBrowseNodeGenerator {
    public List<BrowsePath> computeAssetPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        if (asset.component().isPresent()) {
            List<BrowsePath> paths = this.computeComponentPaths(asset);
            String lastSegment = this.lastSegment(asset.path());
            BrowsePathBuilder.appendPath(paths, (String)lastSegment);
            return paths;
        }
        return super.computeAssetPaths(asset);
    }

    public List<BrowsePath> computeComponentPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        Component component = (Component)asset.component().orElseThrow(() -> new RuntimeException("Component is not presented for asset: {}" + asset.path()));
        List assetPaths = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)asset.path());
        List browsePaths = BrowsePathBuilder.fromPaths(assetPaths.subList(0, assetPaths.size() - 1), (boolean)true);
        if (!((BrowsePath)browsePaths.get(browsePaths.size() - 1)).getDisplayName().equals(component.name())) {
            BrowsePathBuilder.appendPath((List)browsePaths, (String)component.name(), (String)this.computeRequestPath(browsePaths, component.name()));
        }
        String requestPath = this.computeRequestPath(browsePaths, component.version());
        BrowsePathBuilder.appendPath((List)browsePaths, (String)component.version(), (String)requestPath);
        return browsePaths;
    }

    private String computeRequestPath(List<BrowsePath> browsePaths, String path) {
        return String.valueOf(browsePaths.get(browsePaths.size() - 1).getRequestPath()) + path + "/";
    }
}

