/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.datastore.RContentFacet;
import com.sonatype.nexus.repository.r.internal.util.RDescriptionUtils;
import com.sonatype.nexus.repository.r.internal.util.RMetadataUtils;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="r")
public class RContentFacetImpl
extends ContentFacetSupport
implements RContentFacet {
    @Inject
    public RContentFacetImpl(@Named(value="r") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    protected WritePolicy writePolicy(Asset asset) {
        String assetKind;
        WritePolicy policy = super.writePolicy(asset);
        if (WritePolicy.ALLOW_ONCE == policy && ((assetKind = asset.kind()).equals(AssetKind.PACKAGES.name()) || assetKind.equals(AssetKind.RDS_METADATA.name()))) {
            return WritePolicy.ALLOW;
        }
        return policy;
    }

    @Override
    public Iterable<FluentAsset> getAssetsByKind(String kind) {
        Preconditions.checkNotNull((Object)kind);
        String filterString = " kind = #{filterParams.assetKind} ";
        Map<String, String> filterParams = Collections.singletonMap("assetKind", kind);
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)this.assets().byFilter(filterString, filterParams)).browse(arg_0, arg_1));
    }

    @Override
    public Optional<FluentAsset> getAsset(String assetPath) {
        Preconditions.checkNotNull((Object)assetPath);
        return this.assets().path(this.normalizeAssetPath(assetPath)).find();
    }

    @Override
    public FluentAsset putMetadata(Payload payload, String assetPath, AssetKind assetKind) {
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)((Object)assetKind));
        Preconditions.checkNotNull((Object)assetPath);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, RMetadataUtils.HASH_ALGORITHMS);){
            return this.assets().path(this.normalizeAssetPath(assetPath)).kind(assetKind.name()).blob(tempBlob).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public FluentAsset putPackage(Payload payload, String assetPath) {
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)assetPath);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, RMetadataUtils.HASH_ALGORITHMS);){
            Map<String, String> attributes = RDescriptionUtils.extractDescriptionFromArchive(assetPath, (InputStreamSupplier)tempBlob);
            String name = attributes.get("Package");
            String version = attributes.get("Version");
            String namespace = RPathUtils.removeInitialSlashFromPath(RPathUtils.getBasePath(assetPath));
            FluentComponent component = this.findOrCreateComponent(name, namespace, version);
            return component.asset(this.normalizeAssetPath(assetPath)).kind(AssetKind.ARCHIVE.name()).attributes("r", attributes).blob(tempBlob).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentComponent findOrCreateComponent(String name, String namespace, String version) {
        return this.components().name(name).namespace(namespace).version(version).getOrCreate();
    }

    private String normalizeAssetPath(String path) {
        return StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

