/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore;

import com.sonatype.nexus.repository.r.datastore.RContentFacet;
import com.sonatype.nexus.repository.r.internal.util.PackageValidator;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;

@Singleton
@Named(value="r")
public class RUploadHandler
extends UploadHandlerSupport {
    private static final String PATH_ID = "pathId";
    private static final String PACKAGE_PATH_DISPLAY = "Package Path";
    private final VariableResolverAdapter variableResolverAdapter;
    private final ContentPermissionChecker contentPermissionChecker;
    private UploadDefinition definition;

    @Inject
    public RUploadHandler(Set<UploadDefinitionExtension> uploadDefinitionExtensions, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker) {
        super(uploadDefinitionExtensions);
        this.variableResolverAdapter = variableResolverAdapter;
        this.contentPermissionChecker = contentPermissionChecker;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        AssetUpload assetUpload = (AssetUpload)upload.getAssetUploads().get(0);
        PartPayload payload = assetUpload.getPayload();
        Map fields = assetUpload.getFields();
        String uploadPath = RPathUtils.removeInitialSlashFromPath((String)fields.get(PATH_ID));
        String assetPath = RPathUtils.buildPath(uploadPath, payload.getName());
        this.ensurePermitted(repository.getName(), "r", assetPath, Collections.emptyMap());
        PackageValidator.validateArchiveUploadPath(assetPath);
        FluentAsset fluentAsset = ((RContentFacet)repository.facet(RContentFacet.class)).putPackage((Payload)payload, assetPath);
        Content content = fluentAsset.download();
        return new UploadResponse(Collections.singletonList(content), Collections.singletonList(fluentAsset.path()));
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            List<UploadFieldDefinition> assetField = Collections.singletonList(new UploadFieldDefinition(PATH_ID, PACKAGE_PATH_DISPLAY, null, false, UploadFieldDefinition.Type.STRING, null));
            this.definition = this.getDefinition("r", false, Collections.emptyList(), assetField, null);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }
}

