/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.schedule;

import java.util.Date;
import java.util.Set;
import java.util.function.Function;
import org.sonatype.nexus.scheduling.schedule.Schedule;

public class Weekly
extends Schedule {
    public static final String TYPE = "weekly";

    public Weekly(Date startAt, Set<Weekday> daysToRun) {
        super(TYPE);
        this.set("schedule.startAt", Weekly.dateToString(startAt));
        this.set("schedule.daysToRun", Weekly.setToCsv(daysToRun, Weekday.dayToString));
    }

    public Date getStartAt() {
        return Weekly.stringToDate(this.get("schedule.startAt"));
    }

    public Set<Weekday> getDaysToRun() {
        return Weekly.csvToSet(this.get("schedule.daysToRun"), Weekday.stringToDay);
    }

    public static enum Weekday {
        SUN,
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT;

        public static final Function<Weekday, String> dayToString;
        public static final Function<String, Weekday> stringToDay;

        static {
            dayToString = Enum::name;
            stringToDay = Weekday::valueOf;
        }
    }
}

