/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.schedule;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Daily;
import org.sonatype.nexus.scheduling.schedule.Hourly;
import org.sonatype.nexus.scheduling.schedule.Manual;
import org.sonatype.nexus.scheduling.schedule.Monthly;
import org.sonatype.nexus.scheduling.schedule.Now;
import org.sonatype.nexus.scheduling.schedule.Once;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.scheduling.schedule.Weekly;

public class ScheduleDeserializer
extends StdDeserializer<Schedule> {
    private static final long serialVersionUID = 4245698506536873052L;

    public ScheduleDeserializer() {
        super(Schedule.class);
    }

    public Schedule deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.readValueAsTree();
        String type = node.get("type").textValue();
        if ("monthly".equals(type)) {
            Date date = this.parseDate(node.get("startAt"));
            Set<Monthly.CalendarDay> daysToRun = this.parseCalendarDays(node.get("daysToRun"));
            return new Monthly(date, daysToRun);
        }
        if ("weekly".equals(type)) {
            Date date = this.parseDate(node.get("startAt"));
            Set<Weekly.Weekday> daysToRun = this.parseDaysToRun(node.get("daysToRun"));
            return new Weekly(date, daysToRun);
        }
        if ("daily".equals(type)) {
            Date date = this.parseDate(node.get("startAt"));
            return new Daily(date);
        }
        if ("hourly".equals(type)) {
            Date date = this.parseDate(node.get("startAt"));
            return new Hourly(date);
        }
        if ("once".equals(type)) {
            Date date = this.parseDate(node.get("startAt"));
            return new Once(date);
        }
        if ("cron".equals(type)) {
            Date date = this.parseDate(node.get("startAt"));
            String cronExpression = node.get("cronExpression").asText();
            String zoneId = node.get("timeZone").asText();
            return new Cron(date, cronExpression, zoneId);
        }
        if ("manual".equals(type)) {
            return new Manual();
        }
        if ("now".equals(type)) {
            return new Now();
        }
        throw new UnsupportedEncodingException("Can't determine the class type: " + type);
    }

    private Set<Monthly.CalendarDay> parseCalendarDays(JsonNode jsonNode) {
        HashSet<Monthly.CalendarDay> calendarDays = new HashSet<Monthly.CalendarDay>();
        if (jsonNode.isArray()) {
            Iterator elements = jsonNode.elements();
            while (elements.hasNext()) {
                JsonNode calendarDayElement = (JsonNode)elements.next();
                int day = calendarDayElement.get("day").asInt();
                calendarDays.add(Monthly.CalendarDay.day(day));
            }
        }
        return calendarDays;
    }

    private Set<Weekly.Weekday> parseDaysToRun(JsonNode jsonNode) {
        HashSet<Weekly.Weekday> weekdays = new HashSet<Weekly.Weekday>();
        if (jsonNode.isArray()) {
            Iterator elements = jsonNode.elements();
            while (elements.hasNext()) {
                String weekday = ((JsonNode)elements.next()).asText();
                weekdays.add(Weekly.Weekday.valueOf(weekday));
            }
        }
        return weekdays;
    }

    private Date parseDate(JsonNode jsonNode) throws UnsupportedEncodingException {
        if (jsonNode.isTextual()) {
            String startAt = jsonNode.asText();
            OffsetDateTime odt = OffsetDateTime.parse(startAt);
            return Date.from(odt.toInstant());
        }
        if (jsonNode.isLong()) {
            long startAt = jsonNode.longValue();
            return new Date(startAt);
        }
        throw new UnsupportedEncodingException("Can't determine date format");
    }
}

