/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal;

import com.google.common.base.Preconditions;
import java.util.concurrent.Future;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.Freezable;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Priority(value=-2147483648)
@Singleton
public class TaskActivation
extends StateGuardLifecycleSupport
implements Freezable {
    private final SchedulerSPI scheduler;
    private volatile boolean frozen;

    @Inject
    public TaskActivation(SchedulerSPI scheduler) {
        this.scheduler = (SchedulerSPI)Preconditions.checkNotNull((Object)scheduler);
    }

    protected void doStart() throws Exception {
        if (!this.isFrozen()) {
            this.scheduler.resume();
        }
    }

    protected void doStop() throws Exception {
        this.scheduler.pause();
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        this.frozen = true;
        if (this.isStarted()) {
            this.scheduler.pause();
            this.scheduler.listsTasks().stream().filter(taskInfo -> !this.maybeCancel((TaskInfo)taskInfo)).forEach(taskInfo -> this.log.warn("Unable to cancel task: {}", (Object)taskInfo.getName()));
        }
    }

    public void unfreeze() {
        this.frozen = false;
        if (this.isStarted()) {
            this.scheduler.resume();
        }
    }

    private boolean maybeCancel(TaskInfo taskInfo) {
        Future<?> future = taskInfo.getCurrentState().getFuture();
        return future == null || future.cancel(false);
    }
}

