/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;

@Named(value="Scheduler")
@Singleton
public class SchedulerHealthCheck
extends HealthCheck {
    private final Provider<SchedulerSPI> scheduler;

    @Inject
    public SchedulerHealthCheck(Provider<SchedulerSPI> scheduler) {
        this.scheduler = (Provider)Preconditions.checkNotNull(scheduler);
    }

    protected HealthCheck.Result check() {
        List<String> missingTaskDescriptions = ((SchedulerSPI)this.scheduler.get()).getMissingTriggerDescriptions();
        return missingTaskDescriptions.isEmpty() ? HealthCheck.Result.healthy() : HealthCheck.Result.unhealthy((String)this.reason(missingTaskDescriptions));
    }

    private String reason(List<String> missingTaskDescriptions) {
        String taskDescriptions = String.join((CharSequence)", ", missingTaskDescriptions);
        return String.format("%s tasks require frequency updates: %s", missingTaskDescriptions.size(), taskDescriptions);
    }
}

