/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.PeriodicJobService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@Singleton
public class PeriodicJobServiceImpl
extends StateGuardLifecycleSupport
implements PeriodicJobService {
    private ScheduledExecutorService executor;
    private int activeClients;

    @Override
    public synchronized void startUsing() throws Exception {
        if (this.activeClients == 0) {
            this.start();
        }
        ++this.activeClients;
    }

    @Override
    public synchronized void stopUsing() throws Exception {
        Preconditions.checkState((this.activeClients > 0 ? 1 : 0) != 0, (Object)"Not started");
        --this.activeClients;
        if (this.activeClients == 0) {
            this.stop();
        }
    }

    protected void doStart() throws Exception {
        this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NexusThreadFactory("periodic", "scheduling"));
    }

    protected void doStop() throws Exception {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            this.log.warn("Failed to terminate thread pool in allotted time");
        }
        this.executor = null;
    }

    @Override
    public void runOnce(Runnable runnable, int delaySeconds) {
        this.executor.schedule(runnable, (long)delaySeconds, TimeUnit.SECONDS);
    }

    @Override
    @Guarded(by={"STARTED"})
    public PeriodicJobService.PeriodicJob schedule(Runnable runnable, int repeatPeriodSeconds) {
        ScheduledFuture<?> scheduledFuture = this.executor.scheduleAtFixedRate(this.wrap(runnable), repeatPeriodSeconds, repeatPeriodSeconds, TimeUnit.SECONDS);
        return () -> {
            boolean bl = scheduledFuture.cancel(false);
        };
    }

    @Override
    @Guarded(by={"STARTED"})
    public PeriodicJobService.PeriodicJob schedule(Runnable runnable, Duration delay, Duration repeatPeriod) {
        ScheduledFuture<?> scheduledFuture = this.executor.scheduleAtFixedRate(this.wrap(runnable), delay.toMillis(), repeatPeriod.toMillis(), TimeUnit.MILLISECONDS);
        return () -> {
            boolean bl = scheduledFuture.cancel(false);
        };
    }

    private Runnable wrap(Runnable inner) {
        return () -> {
            try {
                inner.run();
            }
            catch (Exception e) {
                this.log.error("Periodic job threw exception", (Throwable)e);
            }
        };
    }
}

