/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.events;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nullable;
import org.sonatype.nexus.scheduling.CurrentState;
import org.sonatype.nexus.scheduling.LastRunState;
import org.sonatype.nexus.scheduling.TaskInfo;

public abstract class TaskEvent {
    private final Date eventDate = new Date();
    private final TaskInfo taskInfo;
    private final CurrentState currentState;
    private final LastRunState lastRunState;

    public TaskEvent(TaskInfo taskInfo) {
        this.taskInfo = (TaskInfo)Preconditions.checkNotNull((Object)taskInfo);
        this.currentState = taskInfo.getCurrentState();
        this.lastRunState = taskInfo.getLastRunState();
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public CurrentState getCurrentState() {
        return this.currentState;
    }

    @Nullable
    public LastRunState getLastRunState() {
        return this.lastRunState;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "nexusTask=" + this.getTaskInfo().getConfiguration() + ", currentState=" + this.currentState + ", lastRunState=" + this.lastRunState + '}';
    }
}

