/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.scheduling.ExternalTaskState;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptor;
import org.sonatype.nexus.scheduling.TaskFactory;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.events.TaskScheduledEvent;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.scheduling.schedule.ScheduleFactory;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;

@Singleton
@Named
public class TaskSchedulerImpl
extends ComponentSupport
implements TaskScheduler {
    private final EventManager eventManager;
    private final TaskFactory taskFactory;
    private final Provider<SchedulerSPI> scheduler;

    @Inject
    public TaskSchedulerImpl(EventManager eventManager, TaskFactory taskFactory, Provider<SchedulerSPI> scheduler) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.taskFactory = (TaskFactory)Preconditions.checkNotNull((Object)taskFactory);
        this.scheduler = (Provider)Preconditions.checkNotNull(scheduler);
    }

    @Override
    public TaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    private SchedulerSPI getScheduler() {
        SchedulerSPI result = (SchedulerSPI)this.scheduler.get();
        Preconditions.checkState((result != null ? 1 : 0) != 0);
        return result;
    }

    @Override
    public ScheduleFactory getScheduleFactory() {
        ScheduleFactory result = this.getScheduler().scheduleFactory();
        Preconditions.checkState((result != null ? 1 : 0) != 0);
        return result;
    }

    @Override
    public int getRunningTaskCount() {
        return this.getScheduler().getRunningTaskCount();
    }

    @Override
    public int getExecutedTaskCount() {
        return this.getScheduler().getExecutedTaskCount();
    }

    @Override
    public TaskConfiguration createTaskConfigurationInstance(String typeId) {
        Preconditions.checkNotNull((Object)typeId);
        TaskDescriptor descriptor = this.taskFactory.findDescriptor(typeId);
        Preconditions.checkArgument((descriptor != null ? 1 : 0) != 0, (String)"Missing descriptor for task with type-id: %s", (Object)typeId);
        TaskConfiguration config = descriptor.createTaskConfiguration();
        descriptor.initializeConfiguration(config);
        config.setId(UUID.randomUUID().toString());
        config.setTypeId(descriptor.getId());
        config.setTypeName(descriptor.getName());
        config.setName(descriptor.getName());
        config.setVisible(descriptor.isVisible());
        config.setRecoverable(descriptor.isRecoverable());
        config.setExposed(descriptor.isExposed());
        return config;
    }

    @Override
    public TaskInfo submit(TaskConfiguration config) {
        return this.scheduleTask(config, this.getScheduleFactory().now());
    }

    @Override
    public TaskInfo getTaskById(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.getScheduler().getTaskById(id);
    }

    @Override
    public List<TaskInfo> listsTasks() {
        return this.getScheduler().listsTasks();
    }

    @Override
    public TaskInfo scheduleTask(TaskConfiguration config, Schedule schedule) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)schedule);
        config.validate();
        Date now = new Date();
        if (config.getCreated() == null) {
            config.setCreated(now);
        }
        config.setUpdated(now);
        TaskInfo taskInfo = this.getScheduler().scheduleTask(config, schedule);
        this.log.info("Task {} scheduled: {}", (Object)taskInfo.getConfiguration().getTaskLogName(), (Object)taskInfo.getSchedule().getType());
        this.eventManager.post((Object)new TaskScheduledEvent(taskInfo));
        return taskInfo;
    }

    @Override
    public ExternalTaskState toExternalTaskState(TaskInfo taskInfo) {
        return new ExternalTaskState(taskInfo);
    }

    @Override
    public boolean cancel(String id, boolean mayInterruptIfRunning) {
        return this.getScheduler().cancel(id, mayInterruptIfRunning);
    }

    @Override
    @Nullable
    public TaskInfo getTaskByTypeId(String typeId) {
        return this.getScheduler().getTaskByTypeId(typeId);
    }

    @Override
    @Nullable
    public TaskInfo getTaskByTypeId(String typeId, Map<String, String> config) {
        return this.getScheduler().getTaskByTypeId(typeId, config);
    }

    @Override
    public boolean findAndSubmit(String typeId) {
        return this.getScheduler().findAndSubmit(typeId);
    }

    @Override
    public boolean findAndSubmit(String typeId, Map<String, String> config) {
        return this.getScheduler().findAndSubmit(typeId, config);
    }
}

