/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import org.sonatype.nexus.logging.task.TaskLogInfo;
import org.sonatype.nexus.scheduling.LastRunState;
import org.sonatype.nexus.scheduling.TaskNotificationCondition;
import org.sonatype.nexus.scheduling.TaskState;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskConfiguration
implements TaskLogInfo {
    public static final String LAST_RUN_STATE_END_STATE = "lastRunState.endState";
    public static final String LAST_RUN_STATE_RUN_STARTED = "lastRunState.runStarted";
    public static final String LAST_RUN_STATE_RUN_DURATION = "lastRunState.runDuration";
    static final String ID_KEY = ".id";
    static final String NAME_KEY = ".name";
    static final String TYPE_ID_KEY = ".typeId";
    static final String TYPE_NAME_KEY = ".typeName";
    static final String ENABLED_KEY = ".enabled";
    static final String VISIBLE_KEY = ".visible";
    static final String ALERT_EMAIL_KEY = ".alertEmail";
    static final String NOTIFICATION_CONDITION_KEY = ".notificationCondition";
    static final String CREATED_KEY = ".created";
    static final String UPDATED_KEY = ".updated";
    static final String MESSAGE_KEY = ".message";
    static final String RECOVERABLE_KEY = ".recoverable";
    static final String EXPOSED_KEY = ".exposed";
    static final String LOG_STATE_KEY = ".logState";
    @JsonProperty(value="configuration")
    private final Map<String, String> configuration;

    public TaskConfiguration() {
        this.configuration = new HashMap<String, String>();
    }

    public TaskConfiguration(TaskConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configuration = new HashMap<String, String>(configuration.configuration);
        this.validate();
    }

    public void validate() {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.getId()) ? 1 : 0) != 0, (Object)"Incomplete task configuration: id");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.getTypeId()) ? 1 : 0) != 0, (Object)"Incomplete task configuration: typeId");
    }

    public String getTaskLogName() {
        String name = Strings.isNullOrEmpty((String)this.getName()) ? this.getTypeName() : this.getName();
        return String.format("'%s' [%s]", name, this.getTypeId());
    }

    public TaskConfiguration apply(TaskConfiguration from) {
        Preconditions.checkNotNull((Object)from);
        from.validate();
        this.configuration.putAll(from.configuration);
        return this;
    }

    public Map<String, String> asMap() {
        return ImmutableMap.copyOf(this.configuration);
    }

    public String toString() {
        return this.configuration.toString();
    }

    public String getId() {
        return this.getString(ID_KEY);
    }

    public void setId(String id) {
        Preconditions.checkNotNull((Object)id);
        this.setString(ID_KEY, id);
    }

    public String getName() {
        return this.getString(NAME_KEY);
    }

    public void setName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.setString(NAME_KEY, name);
    }

    public String getTypeId() {
        return this.getString(TYPE_ID_KEY);
    }

    public void setTypeId(String typeId) {
        Preconditions.checkNotNull((Object)typeId);
        this.setString(TYPE_ID_KEY, typeId);
    }

    public String getTypeName() {
        return this.getString(TYPE_NAME_KEY);
    }

    public void setTypeName(String typeName) {
        Preconditions.checkNotNull((Object)typeName);
        this.setString(TYPE_NAME_KEY, typeName);
    }

    public boolean isEnabled() {
        return this.getBoolean(ENABLED_KEY, true);
    }

    public void setEnabled(boolean enabled) {
        this.setBoolean(ENABLED_KEY, enabled);
    }

    public boolean isVisible() {
        return this.getBoolean(VISIBLE_KEY, true);
    }

    public void setVisible(boolean visible) {
        this.setBoolean(VISIBLE_KEY, visible);
    }

    public boolean isExposed() {
        return this.getBoolean(EXPOSED_KEY, true);
    }

    public void setExposed(boolean exposed) {
        this.setBoolean(EXPOSED_KEY, exposed);
    }

    @Nullable
    public String getAlertEmail() {
        return this.getString(ALERT_EMAIL_KEY);
    }

    public void setAlertEmail(String email) {
        this.setString(ALERT_EMAIL_KEY, email);
    }

    public TaskNotificationCondition getNotificationCondition() {
        return TaskNotificationCondition.valueOf(this.getString(NOTIFICATION_CONDITION_KEY, TaskNotificationCondition.DEFAULT.name()));
    }

    public void setNotificationCondition(TaskNotificationCondition condition) {
        this.setString(NOTIFICATION_CONDITION_KEY, condition.name());
    }

    @Nullable
    public Date getCreated() {
        return this.getDate(CREATED_KEY, null);
    }

    public void setCreated(Date date) {
        Preconditions.checkNotNull((Object)date);
        this.setDate(CREATED_KEY, date);
    }

    @Nullable
    public Date getUpdated() {
        return this.getDate(UPDATED_KEY, null);
    }

    public void setUpdated(Date date) {
        Preconditions.checkNotNull((Object)date);
        this.setDate(UPDATED_KEY, date);
    }

    @Nullable
    public String getMessage() {
        return this.getString(MESSAGE_KEY);
    }

    public void setMessage(String message) {
        this.setString(MESSAGE_KEY, message);
    }

    public boolean isRecoverable() {
        return this.getBoolean(RECOVERABLE_KEY, false);
    }

    public void setRecoverable(boolean requestRecovery) {
        this.setBoolean(RECOVERABLE_KEY, requestRecovery);
    }

    public boolean hasLastRunState() {
        return this.getString(LAST_RUN_STATE_END_STATE) != null;
    }

    @Nullable
    public LastRunState getLastRunState() {
        if (this.hasLastRunState()) {
            String endStateString = this.getString(LAST_RUN_STATE_END_STATE);
            long runStarted = this.getLong(LAST_RUN_STATE_RUN_STARTED, System.currentTimeMillis());
            long runDuration = this.getLong(LAST_RUN_STATE_RUN_DURATION, 0L);
            return new LastRunStateImpl(TaskState.valueOf(endStateString), new Date(runStarted), runDuration);
        }
        return null;
    }

    public void setLastRunState(TaskState endState, Date runStarted, long runDuration) {
        Preconditions.checkNotNull((Object)((Object)endState));
        Preconditions.checkNotNull((Object)runStarted);
        Preconditions.checkArgument((runDuration >= 0L ? 1 : 0) != 0);
        this.setString(LAST_RUN_STATE_END_STATE, endState.name());
        this.setLong(LAST_RUN_STATE_RUN_STARTED, runStarted.getTime());
        this.setLong(LAST_RUN_STATE_RUN_DURATION, runDuration);
    }

    public boolean isLogTaskState() {
        return this.getBoolean(LOG_STATE_KEY, true);
    }

    public void setLogTaskState(boolean logTaskState) {
        this.setBoolean(LOG_STATE_KEY, logTaskState);
    }

    public Date getDate(String key, Date defaultValue) {
        return Optional.ofNullable(key).map(this::getString).map(DateTime::new).map(AbstractInstant::toDate).orElse(defaultValue);
    }

    public void setDate(String key, Date date) {
        this.setString(key, date, d -> new DateTime(d).toString());
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getString(key, String.valueOf(defaultValue)));
    }

    public void setBoolean(String key, boolean value) {
        this.setString(key, value, String::valueOf);
    }

    public int getInteger(String key, int defaultValue) {
        return Integer.parseInt(this.getString(key, String.valueOf(defaultValue)));
    }

    public void setInteger(String key, int value) {
        this.setString(key, value, String::valueOf);
    }

    public long getLong(String key, long defaultValue) {
        return Long.parseLong(this.getString(key, String.valueOf(defaultValue)));
    }

    public void setLong(String key, long value) {
        this.setString(key, value, String::valueOf);
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Preconditions.checkNotNull((Object)key);
        return this.configuration.getOrDefault(key, defaultValue);
    }

    public void setString(String key, String value) {
        this.setString(key, value, Function.identity());
    }

    <T> void setString(String key, T value, Function<T, String> f) {
        Preconditions.checkNotNull((Object)key);
        if (value == null || Strings.isNullOrEmpty((String)f.apply(value))) {
            this.configuration.remove(key);
        } else {
            this.configuration.put(key, f.apply(value));
        }
    }

    public boolean containsKey(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.configuration.containsKey(key);
    }

    public void addAll(Map<String, String> attributes) {
        attributes.entrySet().forEach(entry -> {
            String string = this.configuration.put((String)entry.getKey(), (String)entry.getValue());
        });
    }

    private static class LastRunStateImpl
    implements LastRunState {
        private final TaskState endState;
        private final Date runStarted;
        private final long runDuration;

        public LastRunStateImpl(TaskState endState, Date runStarted, long runDuration) {
            this.endState = endState;
            this.runStarted = runStarted;
            this.runDuration = runDuration;
        }

        @Override
        public TaskState getEndState() {
            return this.endState;
        }

        @Override
        public Date getRunStarted() {
            return this.runStarted;
        }

        @Override
        public long getRunDuration() {
            return this.runDuration;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "endState=" + (Object)((Object)this.endState) + ", runStarted=" + this.runStarted + ", runDuration=" + this.runDuration + '}';
        }
    }
}

