/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonatype.nexus.scheduling.LastRunState;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskState;

public class ExternalTaskState {
    private final TaskState state;
    private final TaskState lastEndState;
    private final Date lastRunStarted;
    private final Long lastRunDuration;

    public ExternalTaskState(TaskState state, @Nullable TaskState lastEndState, @Nullable Date lastRunStarted, @Nullable Long lastRunDuration) {
        this.state = (TaskState)((Object)Preconditions.checkNotNull((Object)((Object)state)));
        this.lastEndState = lastEndState;
        this.lastRunStarted = lastRunStarted;
        this.lastRunDuration = lastRunDuration;
    }

    public ExternalTaskState(TaskInfo taskInfo) {
        this(taskInfo.getCurrentState().getState(), Optional.ofNullable(taskInfo.getLastRunState()).map(LastRunState::getEndState).orElse(null), Optional.ofNullable(taskInfo.getLastRunState()).map(LastRunState::getRunStarted).orElse(null), Optional.ofNullable(taskInfo.getLastRunState()).map(LastRunState::getRunDuration).orElse(null));
    }

    public TaskState getState() {
        return this.state;
    }

    @Nullable
    public TaskState getLastEndState() {
        return this.lastEndState;
    }

    @Nullable
    public Date getLastRunStarted() {
        return this.lastRunStarted;
    }

    @Nullable
    public Long getLastRunDuration() {
        return this.lastRunDuration;
    }
}

