/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.datastore.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.gitlfs.datastore.GitLfsContentFacet;
import org.sonatype.nexus.repository.gitlfs.datastore.internal.PathUtils;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsCoordinate;
import org.sonatype.nexus.repository.gitlfs.internal.utils.GitLfsJsonUtils;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class GitLfsHostedVerifyHandler
implements Handler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        GitLfsCoordinate coordinate;
        Payload payload = (Payload)Preconditions.checkNotNull((Object)context.getRequest().getPayload());
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String oid = (String)state.getTokens().get("oid");
        if (oid == null) {
            return this.buildResponse(Status.failure((int)400), null);
        }
        Throwable throwable = null;
        Object var7_7 = null;
        try (InputStream in = payload.openInputStream();){
            coordinate = (GitLfsCoordinate)OBJECT_MAPPER.readValue(in, GitLfsCoordinate.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Optional<String> errorMessage = this.validateStoredContent(context.getRepository(), oid, coordinate);
        if (errorMessage.isPresent()) {
            return this.buildResponse(Status.failure((int)500), GitLfsJsonUtils.buildBatchResponse(errorMessage.get()));
        }
        return this.buildResponse(Status.success((int)200), GitLfsJsonUtils.buildObjectResponse(coordinate, Collections.emptyMap()));
    }

    private Optional<String> validateStoredContent(Repository repository, String oid, GitLfsCoordinate coordinate) {
        GitLfsContentFacet contentFacet = (GitLfsContentFacet)repository.facet(GitLfsContentFacet.class);
        Optional<FluentAsset> assetOpt = contentFacet.get(oid);
        if (!assetOpt.isPresent() || !assetOpt.get().blob().isPresent()) {
            return Optional.of("Object does not exist");
        }
        FluentAsset asset = assetOpt.get();
        if (!Objects.equals(((AssetBlob)asset.blob().get()).blobSize(), coordinate.getSize())) {
            return Optional.of("Sizes do not match");
        }
        if (!Objects.equals(asset.path(), PathUtils.normalizeAssetPath(coordinate.getOid()))) {
            return Optional.of("OIDs do not match");
        }
        return Optional.empty();
    }

    private Response buildResponse(Status status, Map<String, Object> content) throws JsonProcessingException {
        return new Response.Builder().status(status).payload((Payload)new StringPayload(OBJECT_MAPPER.writeValueAsString(content), "application/vnd.git-lfs+json")).build();
    }
}

