/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.datastore.internal;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.gitlfs.datastore.GitLfsContentFacet;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsAbstractHostedBatchEndpointHandler;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsBatchRequestParser;

@Named
@Singleton
public class GitLfsHostedBatchEndpointHandler
extends GitLfsAbstractHostedBatchEndpointHandler {
    @Inject
    public GitLfsHostedBatchEndpointHandler(GitLfsBatchRequestParser batchRequestParser) {
        super(batchRequestParser);
    }

    @Override
    protected boolean savedContentExists(Repository repository, String oid) {
        GitLfsContentFacet contentFacet = (GitLfsContentFacet)repository.facet(GitLfsContentFacet.class);
        return contentFacet.get(oid).isPresent();
    }

    @Override
    protected Optional<Long> savedContentSize(Repository repository, String oid) {
        GitLfsContentFacet contentFacet = (GitLfsContentFacet)repository.facet(GitLfsContentFacet.class);
        Optional<FluentAsset> assetOpt = contentFacet.get(oid);
        return assetOpt.flatMap(Asset::blob).map(AssetBlob::blobSize);
    }
}

