/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.move.RepositoryMover;
import com.sonatype.nexus.repository.move.store.ChangeRepositoryBlobstoreStore;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTask;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskConfiguration;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskValidator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;

@Named
@Singleton
public class RepositoryMoveTaskDescriptor
extends TaskDescriptorSupport {
    public static final String TASK_NAME = "Admin - Change repository blob store";
    public static final String TYPE_ID = "repository.move";
    private static final boolean RECOVERABLE = true;
    public static final String REPOSITORY_NAME = "moveRepositoryName";
    public static final String INITIAL_BLOBSTORE = "moveInitialBlobstore";
    public static final String TARGET_BLOBSTORE = "moveTargetBlobstore";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final RepositoryManager repositoryManager;
    private final Provider<RepositoryMover> repositoryMoverProvider;
    private final ChangeRepositoryBlobstoreStore changeRepositoryBlobstoreStore;
    private final List<RepositoryMoveTaskValidator> validators;

    @Inject
    public RepositoryMoveTaskDescriptor(RepositoryManager repositoryManager, HostedType hostedType, NodeAccess nodeAccess, Provider<RepositoryMover> repositoryMoverProvider, ChangeRepositoryBlobstoreStore changeRepositoryBlobstoreStore, List<RepositoryMoveTaskValidator> validators) {
        super(TYPE_ID, RepositoryMoveTask.class, messages.name(), true, true, true, new FormField[]{new RepositoryCombobox(REPOSITORY_NAME, messages.repositoryNameLabel(), messages.repositoryHelpText(), true).includingAnyOfTypes(new String[]{hostedType.getValue()}), new ComboboxFormField(TARGET_BLOBSTORE, messages.blobstoreNameLabel(), messages.blobStoreHelpText(), true), nodeAccess.isClustered() ? RepositoryMoveTaskDescriptor.newLimitNodeFormField() : null});
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryMoverProvider = (Provider)Preconditions.checkNotNull(repositoryMoverProvider);
        this.changeRepositoryBlobstoreStore = (ChangeRepositoryBlobstoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobstoreStore);
        this.validators = (List)Preconditions.checkNotNull(validators);
    }

    public void initializeConfiguration(TaskConfiguration configuration) {
        configuration.setString("limitnode", "");
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isExposed() {
        return true;
    }

    public TaskConfiguration createTaskConfiguration() {
        return new RepositoryMoveTaskConfiguration(this.repositoryManager, this.changeRepositoryBlobstoreStore, (RepositoryMover)this.repositoryMoverProvider.get(), this.validators);
    }

    public boolean allowConcurrentRun() {
        return false;
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Admin - Change repository blob store")
        public String name();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repositoryNameLabel();

        @MessageBundle.DefaultMessage(value="Select a hosted repository to change its blob store")
        public String repositoryHelpText();

        @MessageBundle.DefaultMessage(value="Destination blob store")
        public String blobstoreNameLabel();

        @MessageBundle.DefaultMessage(value="Select a blob store to move the repository to")
        public String blobStoreHelpText();
    }
}

