/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.move.RepositoryMover;
import com.sonatype.nexus.repository.move.internal.ChangeRepositoryBlobstoreConfiguration;
import com.sonatype.nexus.repository.move.store.ChangeRepositoryBlobstoreStore;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskValidator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.scheduling.TaskConfiguration;

public class RepositoryMoveTaskConfiguration
extends TaskConfiguration {
    private static final String PROMOTED = "-promoted";
    private final RepositoryManager repositoryManager;
    private final ChangeRepositoryBlobstoreStore changeRepositoryBlobstoreStore;
    private final RepositoryMover repositoryMover;
    private final List<RepositoryMoveTaskValidator> validators;

    public RepositoryMoveTaskConfiguration(RepositoryManager repositoryManager, ChangeRepositoryBlobstoreStore changeRepositoryBlobstoreStore, RepositoryMover repositoryMover, List<RepositoryMoveTaskValidator> validators) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.changeRepositoryBlobstoreStore = (ChangeRepositoryBlobstoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobstoreStore);
        this.repositoryMover = (RepositoryMover)Preconditions.checkNotNull((Object)repositoryMover);
        this.validators = (List)Preconditions.checkNotNull(validators);
    }

    public RepositoryMoveTaskConfiguration(RepositoryManager repositoryManager, ChangeRepositoryBlobstoreStore changeRepositoryBlobstoreStore, RepositoryMover repositoryMover, List<RepositoryMoveTaskValidator> validators, TaskConfiguration configuration) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.changeRepositoryBlobstoreStore = (ChangeRepositoryBlobstoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobstoreStore);
        this.repositoryMover = (RepositoryMover)Preconditions.checkNotNull((Object)repositoryMover);
        this.validators = (List)Preconditions.checkNotNull(validators);
        this.addAll(configuration.asMap());
    }

    public String getRepositoryName() {
        return this.getString("moveRepositoryName");
    }

    public String getInitialBlobstore() {
        return this.getString("moveInitialBlobstore");
    }

    public void setInitialBlobstore(String initialBlobstore) {
        this.setString("moveInitialBlobstore", initialBlobstore);
    }

    public String getTargetBlobstore() {
        return this.getString("moveTargetBlobstore");
    }

    public void validate() {
        super.validate();
        String repositoryName = this.getRepositoryName();
        String targetBlobstore = this.getTargetBlobstore();
        String originalBlobStore = (String)this.repositoryManager.get(repositoryName).getConfiguration().attributes("storage").get("blobStoreName");
        if (StringUtils.endsWith((CharSequence)targetBlobstore, (CharSequence)PROMOTED)) {
            throw new ValidationErrorsException("moveTargetBlobstore", "This task cannot be run against a promoted blob store.");
        }
        if (StringUtils.equals((CharSequence)originalBlobStore, (CharSequence)targetBlobstore)) {
            throw new ValidationErrorsException("moveTargetBlobstore", "Task was configured to move contents to the same blobstore");
        }
        if (!this.repositoryMover.findMoveTasks(repositoryName, this.getId()).isEmpty()) {
            throw new ValidationErrorsException("moveTargetBlobstore", "Repository " + repositoryName + " already has a move task created, only one task of this type is supported per repository.");
        }
        ChangeRepositoryBlobstoreConfiguration existing = this.changeRepositoryBlobstoreStore.findByRepositoryName(repositoryName);
        if (existing != null && !targetBlobstore.equals(existing.getTargetBlobstoreName()) && !targetBlobstore.equals(existing.getSourceBlobstoreName())) {
            throw new ValidationErrorsException("moveTargetBlobstore", "Repository " + repositoryName + " already has a move started and not yet completed, until that finishes successfully, you cannot move assets to a different blob store.");
        }
        for (RepositoryMoveTaskValidator validator : this.validators) {
            validator.validate(this);
        }
        this.setInitialBlobstore(originalBlobStore);
    }
}

