/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.move.RepositoryMover;
import com.sonatype.nexus.repository.move.store.ChangeRepositoryBlobstoreStore;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskConfiguration;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskValidator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.scheduling.TaskUtils;

@Named
public class RepositoryMoveTask
extends TaskSupport
implements Cancelable {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final RepositoryMover repositoryMover;
    private final int delaySecondsBeforeCleanup;
    private final TaskUtils taskUtils;
    private final RepositoryManager repositoryManager;
    private final ChangeRepositoryBlobstoreStore changeRepositoryBlobstoreStore;
    private final List<RepositoryMoveTaskValidator> validators;

    @Inject
    public RepositoryMoveTask(RepositoryMover repositoryMover, @Named(value="${nexus.repository.move.delaySecondsBeforeCleanup:-30}") int delaySecondsBeforeCleanup, TaskUtils taskUtils, RepositoryManager repositoryManager, ChangeRepositoryBlobstoreStore changeRepositoryBlobstoreStore, List<RepositoryMoveTaskValidator> validators) {
        this.repositoryMover = (RepositoryMover)Preconditions.checkNotNull((Object)repositoryMover);
        this.delaySecondsBeforeCleanup = delaySecondsBeforeCleanup;
        this.taskUtils = (TaskUtils)Preconditions.checkNotNull((Object)taskUtils);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.changeRepositoryBlobstoreStore = (ChangeRepositoryBlobstoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobstoreStore);
        this.validators = (List)Preconditions.checkNotNull(validators);
    }

    protected Object execute() throws Exception {
        RepositoryMoveTaskConfiguration configuration = new RepositoryMoveTaskConfiguration(this.repositoryManager, this.changeRepositoryBlobstoreStore, this.repositoryMover, this.validators, this.taskConfiguration());
        String repositoryName = configuration.getRepositoryName();
        String targetBlobstore = configuration.getTargetBlobstore();
        String initialBlobStoreName = configuration.getInitialBlobstore();
        for (RepositoryMoveTaskValidator validator : this.validators) {
            validator.validate(configuration);
        }
        this.taskUtils.checkForConflictingTasks(this.getId(), this.getName(), Arrays.asList("blobstore.group.memberRemoval"), (Map)ImmutableMap.of((Object)"fromGroup", Arrays.asList(targetBlobstore, initialBlobStoreName), (Object)"memberToRemove", Arrays.asList(targetBlobstore, initialBlobStoreName)));
        this.repositoryMover.validateRepositoryMove(repositoryName, initialBlobStoreName, targetBlobstore);
        this.repositoryMover.updateRepositoryBlobstoreConfiguration(repositoryName, targetBlobstore);
        this.repositoryMover.initialize(repositoryName, initialBlobStoreName, targetBlobstore);
        this.repositoryMover.moveBlobs(this, repositoryName, initialBlobStoreName, false);
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Waiting {} seconds before cleanup phase", (Object)this.delaySecondsBeforeCleanup);
        TimeUnit.SECONDS.sleep(this.delaySecondsBeforeCleanup);
        this.repositoryMover.moveBlobs(this, repositoryName, initialBlobStoreName, true);
        configuration.setInitialBlobstore(null);
        this.repositoryMover.cleanup(repositoryName);
        return null;
    }

    public String getMessage() {
        return messages.message();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Run repository blobstore move task")
        public String message();
    }
}

