/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal.storage;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.move.internal.ChangeRepositoryBlobstoreConfiguration;
import com.sonatype.nexus.repository.move.internal.storage.ChangeRepositoryBlobstoreDAO;
import com.sonatype.nexus.repository.move.internal.storage.ChangeRepositoryBlobstoreData;
import com.sonatype.nexus.repository.move.store.ChangeRepositoryBlobstoreStore;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.Transactional;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="mybatis")
@Singleton
public class ChangeRepositoryBlobstoreStoreImpl
extends ConfigStoreSupport<ChangeRepositoryBlobstoreDAO>
implements ChangeRepositoryBlobstoreStore {
    @Inject
    public ChangeRepositoryBlobstoreStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    @Transactional
    public List<ChangeRepositoryBlobstoreConfiguration> list() {
        return ImmutableList.copyOf((Iterable)((ChangeRepositoryBlobstoreDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public void create(ChangeRepositoryBlobstoreConfiguration configuration) {
        ((ChangeRepositoryBlobstoreDAO)this.dao()).create((ChangeRepositoryBlobstoreData)configuration);
    }

    @Override
    @Nullable
    @Transactional
    public ChangeRepositoryBlobstoreConfiguration findByRepositoryName(String repository) {
        return ((ChangeRepositoryBlobstoreDAO)this.dao()).read(repository).orElse(null);
    }

    @Override
    @Transactional
    public List<ChangeRepositoryBlobstoreConfiguration> findByBlobStoreName(String blobstore) {
        return StreamSupport.stream(((ChangeRepositoryBlobstoreDAO)this.dao()).findByBlobstoreName(blobstore).spliterator(), false).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void add(String repository, String sourceBlobstore, String targetBlobstore) {
        ChangeRepositoryBlobstoreData data = new ChangeRepositoryBlobstoreData();
        data.setName(repository);
        data.setSourceBlobstoreName(sourceBlobstore);
        data.setTargetBlobstoreName(targetBlobstore);
        data.setStarted(OffsetDateTime.now());
        ((ChangeRepositoryBlobstoreDAO)this.dao()).create(data);
    }

    @Override
    @Transactional
    public void update(String repository, String sourceBlobstore, String targetBlobstore) {
        ChangeRepositoryBlobstoreData data = new ChangeRepositoryBlobstoreData();
        data.setName(repository);
        data.setSourceBlobstoreName(sourceBlobstore);
        data.setTargetBlobstoreName(targetBlobstore);
        data.setStarted(OffsetDateTime.now());
        ((ChangeRepositoryBlobstoreDAO)this.dao()).update(data);
    }

    @Override
    @Transactional
    public void remove(String repository) {
        ((ChangeRepositoryBlobstoreDAO)this.dao()).delete(repository);
    }
}

