/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.move.internal.MoveBlobService;
import com.sonatype.nexus.repository.move.internal.RepositoryMoverSupport;
import com.sonatype.nexus.repository.move.store.ChangeRepositoryBlobstoreStore;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.BlobStoreUtil;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.TaskSupport;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Singleton
public class RepositoryMoverImpl
extends RepositoryMoverSupport {
    private static final int PAGE_SIZE = 16;
    private final BlobStoreUtil blobStoreUtil;

    @Inject
    public RepositoryMoverImpl(RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, ChangeRepositoryBlobstoreStore changeRepositoryBlobstoreStore, TaskScheduler taskScheduler, MoveBlobService moveBlobService, BlobStoreUtil blobStoreUtil) {
        super(repositoryManager, blobStoreManager, changeRepositoryBlobstoreStore, taskScheduler, moveBlobService);
        this.blobStoreUtil = (BlobStoreUtil)Preconditions.checkNotNull((Object)blobStoreUtil);
    }

    @Override
    public void moveBlobs(RepositoryMoveTask caller, String repositoryName, String sourceBlobStoreName, boolean quiet) {
        Repository repository = this.getRepositoryManager().get(repositoryName);
        FluentAssets fluentAssets = ((ContentFacet)repository.facet(ContentFacet.class)).assets();
        Continuation page = fluentAssets.browse(16, null);
        int currentPage = 0;
        int totalAssets = fluentAssets.count();
        while (!page.isEmpty()) {
            this.movePageOfBlobs((Continuation<FluentAsset>)page, repository, sourceBlobStoreName, caller, totalAssets, currentPage++, quiet);
            String token = page.nextContinuationToken();
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Processed {} blobs, continuation {}", (Object)page.size(), (Object)token);
            if (token == null) break;
            page = fluentAssets.browse(16, token);
        }
    }

    private void movePageOfBlobs(Continuation<FluentAsset> fluentAssets, Repository repository, String sourceBlobStoreName, TaskSupport caller, long totalAssets, int currentPage, boolean quiet) {
        this.checkContinuation(caller, repository.getName());
        HashMap blobIdAssets = new HashMap();
        for (FluentAsset asset : fluentAssets) {
            asset.blob().map(AssetBlob::blobRef).ifPresent(blobRef -> {
                FluentAsset fluentAsset2 = blobIdAssets.put(blobRef.getBlobId(), asset);
            });
        }
        ArrayList<BlobId> blobIds = new ArrayList<BlobId>(blobIdAssets.keySet());
        List<Blob> movedBlobs = this.moveBlobIds(sourceBlobStoreName, (String)repository.getConfiguration().attributes("storage").get("blobStoreName", String.class), blobIds, caller.getName(), totalAssets, currentPage, quiet);
        movedBlobs.forEach(movedBlob -> {
            FluentAsset assetToUpdate = (FluentAsset)blobIdAssets.get(movedBlob.getId());
            assetToUpdate.attachIgnoringWritePolicy(movedBlob, this.blobStoreUtil.toHashObjects(((AssetBlob)assetToUpdate.blob().get()).checksums()));
        });
    }
}

