/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.move.RepositoryMover;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.repository.move.RepositoryMoveService;
import org.sonatype.nexus.scheduling.TaskInfo;

@Singleton
@Named
public class RepositoryMoveServiceImpl
extends ComponentSupport
implements RepositoryMoveService {
    private final BlobStoreManager blobStoreManager;
    private final RepositoryMover repositoryMover;

    @Inject
    public RepositoryMoveServiceImpl(BlobStoreManager blobStoreManager, RepositoryMover repositoryMover) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.repositoryMover = (RepositoryMover)Preconditions.checkNotNull((Object)repositoryMover);
    }

    public Blob getIfBeingMoved(BlobRef blobRef, String sourceRepositoryName) {
        List<TaskInfo> moveTasks = this.repositoryMover.findMoveTasks(sourceRepositoryName, null);
        this.log.debug("Checking if repository {} is involved in any move processes", (Object)sourceRepositoryName);
        for (TaskInfo moveTask : moveTasks) {
            try {
                String initialBlobStore = moveTask.getConfiguration().getString("moveInitialBlobstore");
                if (initialBlobStore == null) continue;
                this.log.debug("Checking if {} has {}", (Object)initialBlobStore, (Object)blobRef.getBlobId());
                BlobStore blobStore = this.blobStoreManager.get(initialBlobStore);
                Blob blob = blobStore.get(blobRef.getBlobId());
                if (blob == null) continue;
                this.log.debug("Found blob from repository {} in blobstore {}", (Object)sourceRepositoryName, (Object)blobStore.getBlobStoreConfiguration().getName());
                return blob;
            }
            catch (Exception ex) {
                this.log.debug("Exception caught while checking whether blob was being moved from blobstore", (Throwable)ex);
            }
        }
        this.log.debug("Did not find blob in any blobstore that is involved for move process for repository {}", (Object)sourceRepositoryName);
        return null;
    }
}

