/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class MoveBlobService
extends StateGuardLifecycleSupport {
    private final BlobStoreManager blobStoreManager;
    private int maxConcurrentRequests;
    private ExecutorService executor;
    public static final int PAGE_SIZE = 16;

    @Inject
    public MoveBlobService(BlobStoreManager blobStoreManager, @Named(value="${nexus.repository.move.maxConcurrentRequests:-10}") int maxConcurrentRequests) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    protected List<Blob> moveBlobIds(String sourceBlobStore, String targetBlobStore, List<BlobId> blobIds, String taskName, long totalAssets, int currentPage, boolean quiet) {
        BlobStore source = this.blobStoreManager.get(sourceBlobStore);
        BlobStore target = this.blobStoreManager.get(targetBlobStore);
        AtomicInteger processed = new AtomicInteger(0);
        return blobIds.stream().map(blobId -> () -> {
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Attempting to move blob {} from {} to {}", new Object[]{blobId, sourceBlobStore, targetBlobStore});
            try {
                if (!quiet || source.exists(blobId)) {
                    return this.blobStoreManager.moveBlob(blobId, source, target);
                }
            }
            catch (Exception ex) {
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Failed to move blob with id: {}", blobId, (Object)ex);
            }
            return null;
        }).map(this.executor::submit).map(future -> {
            try {
                Blob movedBlob = (Blob)future.get();
                if (movedBlob != null) {
                    this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Change Repo Blob Store task {} moved {} to the new blob store {} ({} of {})", new Object[]{taskName, movedBlob.getId(), targetBlobStore, 16 * currentPage + processed.incrementAndGet(), totalAssets});
                }
                return movedBlob;
            }
            catch (InterruptedException | ExecutionException exception) {
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "An error occurred while trying to obtain the result of a move blob call.");
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected void doStart() {
        this.executor = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newFixedThreadPool(this.maxConcurrentRequests, (ThreadFactory)new NexusThreadFactory("change-blobstore-moves", "change-blob-moves")));
    }

    protected void doStop() throws InterruptedException {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            this.log.warn("Failed to terminate thread pool in allotted time");
        }
        this.executor = null;
    }
}

