/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="rubygems", from="1.0", to="1.1")
@Dependencies(value={@DependsOn(model="component", version="1.12", checkpoint=true), @DependsOn(model="config", version="1.6", checkpoint=true)})
public class OrientRubygemsUpgrade_1_1
extends DatabaseUpgradeSupport {
    private static final String SELECT_RUBY_REPOSITORIES = "select from repository where recipe_name in ['rubygems-hosted', 'rubygems-proxy']";
    private static final String UPDATE_ASSET_NAME = "update asset set name = name.subString(1) where bucket = ? and name like '/%'";
    private static final String UPDATE_CONTENT_SELECTOR_EXPRESSION = "update selector_selector set attributes.expression = attributes.expression.replace('//','/') where not(attributes is null)";
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String I_REPOSITORY_NAME = new OIndexNameBuilder().type("bucket").property("repository_name").build();
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public OrientRubygemsUpgrade_1_1(@Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() {
        this.updateAssetNames();
        this.updateContentSelectorExpressions();
    }

    private void updateAssetNames() {
        List<String> rubyRepositoryNames;
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            rubyRepositoryNames = db.query((OQuery)new OSQLSynchQuery(SELECT_RUBY_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        if (!rubyRepositoryNames.isEmpty()) {
            OCommandSQL updateAssetCommand = new OCommandSQL(UPDATE_ASSET_NAME);
            throwable2 = null;
            Object var4_6 = null;
            try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
                OIndex bucketIdx = db.getMetadata().getIndexManager().getIndex(I_REPOSITORY_NAME);
                rubyRepositoryNames.forEach(repositoryName -> {
                    this.log.info("Scanning ruby repository, {}, for asset names that need to be changed", repositoryName);
                    OIdentifiable bucket = (OIdentifiable)bucketIdx.get(repositoryName);
                    if (bucket == null) {
                        this.log.warn("Unable to find bucket for {}", repositoryName);
                    } else {
                        int updates = (Integer)db.command((OCommandRequest)updateAssetCommand).execute(new Object[]{bucket.getIdentity()});
                        if (updates > 0) {
                            this.log.info("Updated {} ruby asset(s) in repository {}: removed leading slash from asset.name", (Object)updates, repositoryName);
                        }
                    }
                });
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
    }

    private void updateContentSelectorExpressions() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            int updates = (Integer)db.command((OCommandRequest)new OCommandSQL(UPDATE_CONTENT_SELECTOR_EXPRESSION)).execute(new Object[0]);
            if (updates > 0) {
                this.log.info("Updated {} content selectors, replaced '//' with '/', as ruby assets no longer require a 'double slash' to be found by content selectors", (Object)updates);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

