/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.BundlerGemsPayload;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.rubygems.marshal.SpecsIndex;
import org.sonatype.nexus.repository.rubygems.orient.OrientRubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientBundlerApiUtils;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientGemsUtils;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientRubygemsCommonUtils;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientRubygemsWritePolicySelector;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientSpecsIndexUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientRubygemsContentFacetImpl
extends FacetSupport
implements OrientRubygemsContentFacet {
    private static final List<HashAlgorithm> hashAlgorithms = Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1);

    protected void doValidate(Configuration configuration) throws Exception {
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        ((StorageFacet)this.getRepository().facet(StorageFacet.class)).registerWritePolicySelector((WritePolicySelector)new OrientRubygemsWritePolicySelector());
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content get(@NotNull RubygemsFile file) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAssetWithProperty("name", (Object)file.getPath(), tx.findBucket(this.getRepository()));
        if (asset == null) {
            return null;
        }
        return this.toContent(file, tx, asset);
    }

    private Content toContent(@NotNull RubygemsFile file, StorageTx tx, Asset asset) {
        this.log.trace("get asset {} for {}", (Object)asset, (Object)file);
        Blob blob = tx.requireBlob(asset.requireBlobRef());
        BlobPayload payload = new BlobPayload(blob, AssetKind.SPECS_INDEX.equals((Object)file.getKind()) ? "application/gzip" : asset.requireContentType());
        Content content = new Content((Payload)payload);
        this.log.trace("{}", (Object)payload);
        Content.extractFromAsset((Asset)asset, hashAlgorithms, (AttributesMap)content.getAttributes());
        return content;
    }

    @Override
    @Nullable
    public Content getOrCreateSpecsIndex(@NotNull RubygemsFile file) throws IOException {
        Content specsIndex = this.getCachedSpecsIndex(file);
        if (specsIndex == null) {
            specsIndex = this.getCachedOrNewSpecsIndex(file);
        }
        return specsIndex;
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content getCachedSpecsIndex(RubygemsFile file) throws IOException {
        return this.getOrCreateSpecsIndex(file, true);
    }

    @TransactionalStoreBlob
    protected Content getCachedOrNewSpecsIndex(RubygemsFile file) throws IOException {
        return this.getOrCreateSpecsIndex(file, false);
    }

    @Nullable
    private Content getOrCreateSpecsIndex(RubygemsFile file, boolean fromCacheOnly) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = OrientSpecsIndexUtils.findSpecsIndex(tx, bucket = tx.findBucket(this.getRepository()), file.getPath());
        if (asset == null) {
            if (fromCacheOnly) {
                return null;
            }
            asset = OrientSpecsIndexUtils.createSpecsIndex(tx, bucket, this.getRepository(), file.getPath());
            OrientSpecsIndexUtils.updateSpecsIndex(tx, asset, new SpecsIndex());
        }
        return this.toContent(file, tx, asset);
    }

    @Override
    @TransactionalStoreBlob
    public void putGem(GemCoordinate coordinate, Payload payload) throws IOException {
        this.log.trace("put gem {}", (Object)coordinate);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, OrientRubygemsCommonUtils.HASH_ALGORITHMS);){
            this.hardlinkPutGem(coordinate, tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @TransactionalStoreBlob
    public Asset hardlinkPutGem(GemCoordinate coordinate, TempBlob tempBlob) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        GemSpecification gemspec = GemSpecificationUtils.retrieveGemSpecification((InputStreamSupplier)tempBlob);
        if (coordinate != null && !coordinate.equals(gemspec.getCoordinate())) {
            throw new IllegalArgumentException("filename and gemname from gem do not match");
        }
        Component component = OrientGemsUtils.getOrCreateGemComponent(tx, bucket, this.getRepository(), gemspec.getCoordinate());
        OrientSpecsIndexUtils.addToSpecsIndex(tx, bucket, this.getRepository(), gemspec.getCoordinate());
        OrientBundlerApiUtils.addToBundlerApi(tx, bucket, this.getRepository(), gemspec);
        OrientGemsUtils.updateGemspec(tx, bucket, component, gemspec);
        return OrientGemsUtils.updateGem(tx, bucket, component, gemspec, tempBlob);
    }

    @Override
    @TransactionalStoreBlob
    public Asset hardlinkPutGem(GemCoordinate coordinate, AssetBlob assetBlob) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        GemSpecification gemspec = GemSpecificationUtils.retrieveGemSpecification(() -> assetBlob.getBlob().getInputStream());
        if (coordinate != null && !coordinate.equals(gemspec.getCoordinate())) {
            throw new IllegalArgumentException("filename and gemname from gem do not match");
        }
        Component component = OrientGemsUtils.getOrCreateGemComponent(tx, bucket, this.getRepository(), gemspec.getCoordinate());
        OrientSpecsIndexUtils.addToSpecsIndex(tx, bucket, this.getRepository(), gemspec.getCoordinate());
        OrientBundlerApiUtils.addToBundlerApi(tx, bucket, this.getRepository(), gemspec);
        OrientGemsUtils.updateGemspec(tx, bucket, component, gemspec);
        return OrientGemsUtils.updateGem(tx, bucket, component, gemspec, assetBlob);
    }

    private void hardlinkPutGem(GemCoordinate coordinate, AssetBlob assetBlob, StorageTx tx, Bucket bucket, AttributesMap contentAttributes) throws IOException {
        GemSpecification gemspec = GemSpecificationUtils.retrieveGemSpecification(() -> ((Blob)assetBlob.getBlob()).getInputStream());
        if (coordinate != null && !coordinate.equals(gemspec.getCoordinate())) {
            throw new IllegalArgumentException("filename and gemname from gem do not match");
        }
        Component component = OrientGemsUtils.getOrCreateGemComponent(tx, bucket, this.getRepository(), coordinate);
        OrientSpecsIndexUtils.addToSpecsIndex(tx, bucket, this.getRepository(), coordinate);
        OrientBundlerApiUtils.addToBundlerApi(tx, bucket, this.getRepository(), gemspec);
        OrientGemsUtils.updateGemspec(tx, bucket, component, gemspec);
        this.putGemFile(tx, bucket, coordinate, assetBlob, contentAttributes);
    }

    @Override
    @TransactionalStoreBlob
    public void putRubygemsFile(RubygemsFile rubygemsFile, Path sourceFile, String contentType, AttributesMap contentAttributes, Map<HashAlgorithm, HashCode> hashes, long size) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetBlob assetBlob = tx.createBlob(rubygemsFile.getPath(), sourceFile, hashes, null, contentType, size);
        this.doPutRubygemsFile(rubygemsFile, contentAttributes, tx, assetBlob);
    }

    @Override
    @TransactionalStoreBlob
    public void putRubygemsFile(RubygemsFile rubygemsFile, TempBlob tempBlob, String contentType, AttributesMap contentAttributes) throws IOException {
        Preconditions.checkNotNull((Object)((Object)rubygemsFile));
        Preconditions.checkNotNull((Object)tempBlob);
        Preconditions.checkNotNull((Object)contentType);
        Preconditions.checkNotNull((Object)contentAttributes);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetBlob assetBlob = tx.createBlob(rubygemsFile.getPath(), tempBlob, null, contentType, true);
        this.doPutRubygemsFile(rubygemsFile, contentAttributes, tx, assetBlob);
    }

    private void doPutRubygemsFile(RubygemsFile rubygemsFile, AttributesMap contentAttributes, StorageTx tx, AssetBlob assetBlob) throws IOException {
        Bucket bucket = tx.findBucket(this.getRepository());
        switch (rubygemsFile.getKind()) {
            case GEM: {
                this.log.debug("Adding gem asset {}", (Object)rubygemsFile.getPath());
                this.hardlinkPutGem(rubygemsFile.getCoordinate(), assetBlob, tx, bucket, contentAttributes);
                break;
            }
            case GEMSPEC: {
                this.log.debug("Adding gemspec asset {}", (Object)rubygemsFile.getPath());
                this.putGemspecFile(tx, bucket, rubygemsFile.getCoordinate(), assetBlob, contentAttributes);
                break;
            }
            case SPECS_INDEX: {
                this.log.debug("Adding specs index asset {}", (Object)rubygemsFile.getPath());
                this.putSpecsIndexFile(tx, bucket, rubygemsFile.getPath(), assetBlob, contentAttributes);
                break;
            }
            case BUNDLER_API_DEPENDENCIES: {
                this.log.debug("Adding bundler_api_dependencies asset {}", (Object)rubygemsFile.getPath());
                this.putBundlerApiDependenciesFile(tx, bucket, rubygemsFile.getGems().get(0), assetBlob, contentAttributes);
            }
        }
    }

    @Override
    @NotNull
    @TransactionalTouchBlob
    public Content getBundlerApiDependencies(@Nullable List<String> gems) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        BundlerGems result = new BundlerGems();
        ArrayList<Asset> assets = new ArrayList<Asset>();
        if (gems != null) {
            for (String gem : gems) {
                this.log.trace("load dependencies for {}", (Object)gem);
                Asset asset = OrientBundlerApiUtils.findBundlerApiDependencies(tx, bucket, gem);
                if (asset == null) continue;
                BundlerGems oneGem = OrientBundlerApiUtils.asBundlerGems(tx, asset);
                result.addAll(oneGem.getGems());
                assets.add(asset);
            }
        }
        Content content = new Content((Payload)new BundlerGemsPayload(result));
        content.getAttributes().set("assetList", assets);
        return content;
    }

    @Override
    @TransactionalDeleteBlob
    public Set<String> delete(@NotNull RubygemsFile file) throws IOException {
        this.log.trace("delete {}", (Object)file);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = OrientRubygemsCommonUtils.findAsset(tx, bucket, file);
        return OrientRubygemsCommonUtils.deleteAsset(tx, bucket, this.getRepository(), asset);
    }

    @Override
    @Transactional
    public boolean assetExists(String assetName) {
        Preconditions.checkNotNull((Object)assetName);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.assetExists(assetName, this.getRepository());
    }

    @Override
    @TransactionalStoreMetadata
    public void restoreGem(GemCoordinate gemCoordinate, AssetBlob assetBlob) throws IOException {
        Preconditions.checkNotNull((Object)gemCoordinate);
        Preconditions.checkNotNull((Object)assetBlob);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        this.putGemFile(tx, bucket, gemCoordinate, assetBlob, null);
    }

    @Override
    @TransactionalStoreMetadata
    public void restoreGemSpec(GemCoordinate gemCoordinate, AssetBlob assetBlob) throws IOException {
        Preconditions.checkNotNull((Object)gemCoordinate);
        Preconditions.checkNotNull((Object)assetBlob);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        this.putGemspecFile(tx, bucket, gemCoordinate, assetBlob, null);
    }

    @Override
    @TransactionalStoreMetadata
    public void restoreSpecsIndex(String path, AssetBlob assetBlob) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)assetBlob);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        this.putSpecsIndexFile(tx, bucket, path, assetBlob, null);
    }

    @Override
    @TransactionalStoreMetadata
    public void restoreBundlerApi(String path, AssetBlob assetBlob) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)assetBlob);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        this.putBundlerApiDependenciesFile(tx, bucket, path, assetBlob, null);
    }

    private void putGemFile(StorageTx tx, Bucket bucket, GemCoordinate gemCoordinate, @Nullable AssetBlob assetBlob, AttributesMap contentAttributes) throws IOException {
        Component component = OrientGemsUtils.getOrCreateGemComponent(tx, bucket, this.getRepository(), gemCoordinate);
        Asset asset = OrientGemsUtils.getOrCreateGemAsset(tx, bucket, component, gemCoordinate);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)new CacheInfo(DateTime.now(), null));
        OrientGemsUtils.applyGemspecAttributesToGem(asset, GemSpecificationUtils.retrieveGemSpecification(() -> ((Blob)assetBlob.getBlob()).getInputStream()));
        OrientRubygemsCommonUtils.updateAsset(tx, asset, assetBlob, contentAttributes);
    }

    private void putGemspecFile(StorageTx tx, Bucket bucket, GemCoordinate gemCoordinate, @Nullable AssetBlob assetBlob, AttributesMap contentAttributes) throws IOException {
        Component component = OrientGemsUtils.getOrCreateGemComponent(tx, bucket, this.getRepository(), gemCoordinate);
        Asset asset = OrientGemsUtils.getOrCreateGemspecAsset(tx, bucket, component, gemCoordinate);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)new CacheInfo(DateTime.now(), null));
        OrientRubygemsCommonUtils.updateAsset(tx, asset, assetBlob, contentAttributes);
    }

    private void putSpecsIndexFile(StorageTx tx, Bucket bucket, String path, @Nullable AssetBlob assetBlob, AttributesMap contentAttributes) throws IOException {
        Asset asset = OrientSpecsIndexUtils.getSpecsIndex(tx, bucket, this.getRepository(), path);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)new CacheInfo(DateTime.now(), null));
        OrientRubygemsCommonUtils.updateAsset(tx, asset, assetBlob, contentAttributes);
    }

    private void putBundlerApiDependenciesFile(StorageTx tx, Bucket bucket, String path, @Nullable AssetBlob assetBlob, AttributesMap contentAttributes) throws IOException {
        Asset asset = OrientBundlerApiUtils.getBundlerApiDependencies(tx, bucket, this.getRepository(), path);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)new CacheInfo(DateTime.now(), null));
        OrientRubygemsCommonUtils.updateAsset(tx, asset, assetBlob, contentAttributes);
    }
}

