/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientBundlerApiUtils;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientGemsUtils;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientSpecsIndexUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class OrientRubygemsCommonUtils {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1);
    private static final Logger log = (Logger)Preconditions.checkNotNull((Object)Loggers.getLogger(OrientRubygemsCommonUtils.class));

    private OrientRubygemsCommonUtils() {
    }

    public static Set<String> deleteAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @Nullable Asset asset) throws IOException {
        return OrientRubygemsCommonUtils.deleteAsset(tx, bucket, repository, asset, true);
    }

    public static Set<String> deleteAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @Nullable Asset asset, boolean deleteBlob) throws IOException {
        if (asset == null) {
            return Collections.emptySet();
        }
        String assetKind = Objects.toString(asset.formatAttributes().get("asset_kind"));
        if (!AssetKind.GEM.name().equals(assetKind)) {
            log.trace("Did not delete: {}", (Object)asset);
            return Collections.emptySet();
        }
        Component component = tx.findComponentInBucket(asset.componentId(), bucket);
        GemCoordinate coordinate = OrientGemsUtils.toGemCoordinate(component, asset);
        OrientSpecsIndexUtils.deleteFromSpecsIndex(tx, bucket, repository, coordinate);
        OrientBundlerApiUtils.deleteFromBundlerApi(tx, bucket, coordinate);
        String removedGemspec = OrientGemsUtils.deleteGemspec(tx, component, coordinate);
        log.trace("Deleting asset: {}", (Object)asset);
        tx.deleteAsset(asset, deleteBlob);
        if (!tx.browseAssets(component).iterator().hasNext()) {
            log.trace("Deleting component: {}", (Object)component);
            tx.deleteComponent(component, deleteBlob);
        }
        HashSet<String> removedAssetNames = new HashSet<String>();
        removedAssetNames.add(asset.name());
        if (removedGemspec != null) {
            removedAssetNames.add(removedGemspec);
        }
        return removedAssetNames;
    }

    @Nullable
    public static Asset findAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull RubygemsFile file) {
        return OrientRubygemsCommonUtils.findAsset(tx, bucket, file.getPath());
    }

    @Nullable
    public static Asset findAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull String path) {
        return tx.findAssetWithProperty("name", (Object)path, bucket);
    }

    @NotNull
    public static AssetBlob updateAsset(@NotNull StorageTx tx, @NotNull Asset asset, @NotNull InputStreamSupplier stream) throws IOException {
        return OrientRubygemsCommonUtils.updateAsset(tx, asset, null, stream);
    }

    @NotNull
    public static AssetBlob updateAsset(@NotNull StorageTx tx, @NotNull Asset asset, @Nullable AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) throws IOException {
        if (contentAttributes != null) {
            Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
        }
        tx.attachBlob(asset, assetBlob);
        tx.saveAsset(asset);
        return assetBlob;
    }

    @NotNull
    public static AssetBlob updateAsset(@NotNull StorageTx tx, @NotNull Asset asset, @Nullable Content content, @NotNull InputStreamSupplier stream) throws IOException {
        OrientRubygemsCommonUtils.applyLastModified(asset, content);
        AssetBlob blob = tx.setBlob(asset, asset.name(), stream, HASH_ALGORITHMS, null, "application/octet-stream", true);
        tx.saveAsset(asset);
        return blob;
    }

    @NotNull
    public static AssetBlob updateAsset(@NotNull StorageTx tx, @NotNull Asset asset, @Nullable Content content, @NotNull TempBlob tempBlob) throws IOException {
        OrientRubygemsCommonUtils.applyLastModified(asset, content);
        AssetBlob blob = tx.setBlob(asset, asset.name(), tempBlob, null, "application/octet-stream", true);
        tx.saveAsset(asset);
        return blob;
    }

    public static void applyLastModified(@NotNull Asset asset, @Nullable Content content) {
        AttributesMap contentAttributes = Content.maintainLastModified((Asset)asset, (AttributesMap)(content == null ? null : content.getAttributes()));
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
    }

    public static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }
}

