/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.RubygemsRepairMetadata;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.rubygems.marshal.SpecsIndex;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientBundlerApiUtils;
import org.sonatype.nexus.repository.rubygems.orient.internal.OrientSpecsIndexUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class OrientRubygemsRepairMetadata
extends ComponentSupport
implements RubygemsRepairMetadata {
    private static final String BEGINNING_ID = "#-1:-1";
    private static final String ASSETS_WHERE = "@rid > :rid";
    private static final String ASSETS_SUFFIX = "ORDER BY @rid LIMIT :limit";
    private static final int BATCH_SIZE = 100;
    private static final List<String> SPECS_LIST = Arrays.asList(RubygemsFile.SPECS_4_8_GZ, RubygemsFile.PRERELEASE_SPECS_4_8_GZ, RubygemsFile.LATEST_SPECS_4_8_GZ);
    private final AssetEntityAdapter assetEntityAdapter;
    private final Type hostedType;
    private final Format format;

    @Inject
    public OrientRubygemsRepairMetadata(AssetEntityAdapter assetEntityAdapter, @Named(value="hosted") Type hostedType, @Named(value="rubygems") Format format) {
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
        this.hostedType = (Type)Preconditions.checkNotNull((Object)hostedType);
        this.format = (Format)Preconditions.checkNotNull((Object)format);
    }

    @Override
    public void repairRepository(Repository repository) {
        if (this.isHostedRubygemsRepository(repository)) {
            this.recreateSpecsIndexes(repository);
            this.doRepairRepository(repository);
        } else {
            this.log.info("Not repairing a proxy repository {}", (Object)repository.getName());
        }
    }

    private void recreateSpecsIndexes(Repository repository) {
        try {
            TransactionalStoreBlob.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).throwing(Exception.class).run(() -> this.doRecreateSpecsIndexes(repository));
        }
        catch (Exception e) {
            this.log.error("Unable to recreate specs index file for repository {}", (Object)repository);
            throw new RuntimeException(e);
        }
    }

    private void doRecreateSpecsIndexes(Repository repository) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(repository);
        for (String file : SPECS_LIST) {
            this.maybeDeleteSpecsIndex(tx, bucket, file);
            Asset specsIndex = OrientSpecsIndexUtils.createSpecsIndex(tx, bucket, repository, file);
            OrientSpecsIndexUtils.updateSpecsIndex(tx, specsIndex, new SpecsIndex());
        }
    }

    private void maybeDeleteSpecsIndex(StorageTx tx, Bucket bucket, String file) {
        Asset asset = OrientSpecsIndexUtils.findSpecsIndex(tx, bucket, file);
        if (asset != null) {
            tx.deleteAsset(asset);
        }
    }

    private boolean isHostedRubygemsRepository(Repository repository) {
        return repository.getFormat().equals((Object)this.format) && repository.getType().equals((Object)this.hostedType);
    }

    private void doRepairRepository(Repository repository) {
        String lastId = BEGINNING_ID;
        while (lastId != null) {
            try {
                lastId = this.processBatch(repository, lastId);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, RuntimeException.class);
                throw new RuntimeException(e);
            }
        }
        this.log.info("Finished processing all ruby packages for repair");
    }

    @Nullable
    private String processBatch(Repository repository, String lastId) throws Exception {
        this.log.info("Processing next batch of rubygems assets for repair. Starting at id = {} with max batch size = {}", (Object)lastId, (Object)100);
        return (String)TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).throwing(Exception.class).call(() -> {
            Iterable<Asset> assets = this.readAssets(repository, lastId);
            return this.updateSpanningData(repository, assets);
        });
    }

    private String updateSpanningData(Repository repository, Iterable<Asset> assets) {
        String lastId = null;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(repository);
        for (Asset asset : assets) {
            Blob blob;
            lastId = this.assetEntityAdapter.recordIdentity((Entity)asset).toString();
            String assetKind = Objects.toString(asset.formatAttributes().get("asset_kind"));
            if (!AssetKind.GEM.name().equals(assetKind) || (blob = tx.getBlob(asset.blobRef())) == null) continue;
            GemCoordinate coordinate = GemCoordinate.fromPath(asset.name());
            try {
                GemSpecification gemspec = GemSpecificationUtils.retrieveGemSpecification(() -> ((Blob)blob).getInputStream());
                OrientSpecsIndexUtils.addToSpecsIndex(tx, bucket, repository, coordinate);
                OrientBundlerApiUtils.addToBundlerApi(tx, bucket, repository, gemspec);
            }
            catch (IOException e) {
                this.log.error("Unable to add {} from repository {} to specs index", new Object[]{asset.name(), repository, e});
            }
        }
        return lastId;
    }

    private Iterable<Asset> readAssets(Repository repository, String lastId) {
        StorageTx storageTx = (StorageTx)UnitOfWork.currentTx();
        ImmutableMap parameters = ImmutableMap.of((Object)"rid", (Object)lastId, (Object)"limit", (Object)100);
        return storageTx.findAssets(ASSETS_WHERE, (Map)parameters, Collections.singletonList(repository), ASSETS_SUFFIX);
    }
}

