/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.tz.FixedDateTimeZone;
import org.sonatype.nexus.repository.rubygems.marshal.IVar;
import org.sonatype.nexus.repository.rubygems.marshal.RawString;
import org.sonatype.nexus.repository.rubygems.marshal.Symbol;
import org.sonatype.nexus.repository.rubygems.marshal.Time;

public class RubyTime
extends IVar<Time> {
    private static final Pattern TIME_OFFSET_PATTERN = Pattern.compile("([\\+-])(\\d\\d):(\\d\\d)(?::(\\d\\d))?");
    private static final Symbol OFFSET = Symbol.create("offset");
    private static final Symbol ZONE = Symbol.create("zone");
    private static DateTimeFormatter OUTPUT_FORMAT = DateTimeFormat.forPattern((String)"Y-MM-dd HH:mm:ss.SSSSSSSSS Z");
    private static DateTimeFormatter GEMSPEC_DATE_FORMAT;

    static {
        String[] formats = new String[]{"Y-MM-dd HH:mm:ss.SSSSSSSSS Z", "Y-MM-dd HH:mm:ss Z", "Y-MM-dd"};
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        Arrays.stream(formats).map(s -> DateTimeFormat.forPattern((String)s).getParser()).forEach(arg_0 -> ((DateTimeFormatterBuilder)builder).appendOptional(arg_0));
        GEMSPEC_DATE_FORMAT = builder.toFormatter();
    }

    public RubyTime() {
        this(DateTime.now().toDateTime(DateTimeZone.UTC));
    }

    public RubyTime(DateTime dateTime) {
        this(dateTime, 0L);
    }

    public RubyTime(DateTime dateTime, long nsec) {
        super(new Time(dateTime, nsec));
        long nanosec = nsec % 1000L;
        if (nanosec != 0L) {
            this.put(Symbol.create("nano_num"), nanosec);
            this.put(Symbol.create("nano_den"), 1);
        }
        byte[] submicro = new byte[2];
        int len = 2;
        submicro[1] = (byte)(nanosec % 10L << 4);
        submicro[0] = (byte)((nanosec /= 10L) % 10L);
        submicro[0] = (byte)(submicro[0] | (byte)((nanosec /= 10L) % 10L << 4));
        if (submicro[1] == 0) {
            len = 1;
        }
        this.put(Symbol.create("submicro"), new RawString(Arrays.copyOf(submicro, len)));
        if (dateTime.getZone() != DateTimeZone.UTC && !dateTime.getZone().equals((Object)DateTimeZone.getDefault())) {
            long offset = dateTime.getZone().getOffset(dateTime.getMillis());
            this.put(OFFSET, offset / 1000L);
            String zone = dateTime.getZone().getShortName(dateTime.getMillis());
            if (!TIME_OFFSET_PATTERN.matcher(zone).matches()) {
                this.put(ZONE, new RawString(zone));
            }
        }
    }

    public static RubyTime today() {
        DateTime today = DateTime.now().toDateTime(DateTimeZone.UTC).withTimeAtStartOfDay();
        return new RubyTime(new DateTime(today.getMillis(), DateTimeZone.UTC));
    }

    @Nullable
    public static RubyTime from(String dateString) {
        if (dateString == null) {
            return null;
        }
        if (dateString.endsWith("Z") && !dateString.endsWith(" Z")) {
            dateString = dateString.replace("Z", " Z");
        }
        try {
            return new RubyTime(DateTime.parse((String)dateString, (DateTimeFormatter)GEMSPEC_DATE_FORMAT).toDateTime(DateTimeZone.UTC));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static DateTimeZone timeZoneWithOffset(String zoneName, Long offset) {
        if (zoneName == null || zoneName.isEmpty()) {
            if (offset != null) {
                return DateTimeZone.forOffsetMillis((int)offset.intValue());
            }
            return null;
        }
        int off = offset == null ? 0 : offset.intValue();
        return new FixedDateTimeZone(zoneName, null, off, off);
    }

    DateTime getDateTime() {
        RawString zone;
        DateTimeZone timeZone;
        DateTime time = ((Time)this.getInstance()).getDateTime();
        Long offset = (Long)this.get(OFFSET);
        if (offset != null) {
            offset = offset * 1000L;
        }
        if ((timeZone = RubyTime.timeZoneWithOffset((zone = (RawString)this.get(ZONE)) == null ? null : zone.toString(), offset)) != null) {
            return time.toDateTime(timeZone);
        }
        return time;
    }

    public String formatted() {
        return this.getDateTime().toString(OUTPUT_FORMAT);
    }
}

