/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.nexus.repository.rubygems.marshal.IVar;
import org.sonatype.nexus.repository.rubygems.marshal.Marshaled;
import org.sonatype.nexus.repository.rubygems.marshal.ObjectCache;
import org.sonatype.nexus.repository.rubygems.marshal.RawString;
import org.sonatype.nexus.repository.rubygems.marshal.RubyObject;
import org.sonatype.nexus.repository.rubygems.marshal.Symbol;
import org.sonatype.nexus.repository.rubygems.marshal.UserDefMarshaled;
import org.sonatype.nexus.repository.rubygems.marshal.UserMarshaled;

public class MarshalDump {
    private static Map<Class<?>, DumpVisitor> dumpers = new HashMap();
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final Symbol.Factory factory = new Symbol.Factory();
    private final ObjectCache cache = new ObjectCache();

    static {
        dumpers.put(Boolean.class, new BooleanVisitor());
        dumpers.put(Integer.class, new NumberVisitor());
        dumpers.put(Long.class, new NumberVisitor());
        dumpers.put(List.class, new ListVisitor());
        dumpers.put(Collection.class, new ListVisitor());
        dumpers.put(Map.class, new MapVisitor());
        dumpers.put(Symbol.class, new SymbolVisitor());
        dumpers.put(RawString.class, new RawStringVisitor());
        dumpers.put(String.class, new StringVisitor());
        dumpers.put(UserMarshaled.class, new UserMarshaledVisitor());
        dumpers.put(RubyObject.class, new RubyObjectVisitor());
        dumpers.put(Marshaled.class, new RubyObjectWrapperVisitor());
        dumpers.put(IVar.class, new IVarVisitor());
        dumpers.put(UserDefMarshaled.class, new BytesVisitor());
    }

    public byte[] toBytes(Object object) throws IOException {
        this.buffer.write(4);
        this.buffer.write(8);
        this.writeObject(object);
        return this.buffer.toByteArray();
    }

    private void writeObject(Object object) throws IOException {
        if (object == null) {
            this.buffer.write(48);
        } else {
            Class<?> clazz = this.getDefiningClass(object);
            if (!dumpers.containsKey(clazz)) {
                throw new RuntimeException("no such key " + clazz + " superclass of " + object.getClass());
            }
            dumpers.get(clazz).accept(this, object);
        }
    }

    private Class<?> getDefiningClass(Object object) {
        if (object instanceof List) {
            return List.class;
        }
        if (object instanceof Map) {
            return Map.class;
        }
        if (object instanceof Collection) {
            return Collection.class;
        }
        if (object instanceof IVar) {
            return IVar.class;
        }
        if (object instanceof Marshaled) {
            if (object instanceof UserMarshaled) {
                return UserMarshaled.class;
            }
            if (object instanceof UserDefMarshaled) {
                return UserDefMarshaled.class;
            }
            return Marshaled.class;
        }
        if (object instanceof RubyObject) {
            return RubyObject.class;
        }
        Class<?> clazz = object.getClass();
        while (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class && clazz.getSuperclass() != Number.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    private void writeRawInteger(long value) {
        if (value > 0L) {
            if (value < 123L) {
                this.buffer.write((int)value + 5);
            } else {
                byte[] bytes = BigInteger.valueOf(value).toByteArray();
                if (bytes[0] == 0) {
                    bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
                }
                this.buffer.write(bytes.length);
                int j = bytes.length - 1;
                while (j > -1) {
                    this.buffer.write(bytes[j]);
                    --j;
                }
            }
        } else if (value < 0L) {
            if (value > -124L) {
                this.buffer.write((int)value - 5);
            } else {
                byte[] bytes = BigInteger.valueOf(value).toByteArray();
                if (bytes[0] == -1) {
                    bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
                }
                this.buffer.write(-bytes.length);
                int j = bytes.length - 1;
                while (j > -1) {
                    this.buffer.write(bytes[j]);
                    --j;
                }
            }
        } else {
            this.buffer.write(0);
        }
    }

    private void writeBytes(byte[] bytes) throws IOException {
        this.writeRawInteger(bytes.length);
        this.buffer.write(bytes);
    }

    private void writeSymbol(Symbol symbol) throws IOException {
        int index = this.factory.indexOf(symbol);
        if (index < 0) {
            this.factory.create(symbol.name);
            this.buffer.write(58);
            this.writeBytes(symbol.name.getBytes(Charset.forName("UTF-8")));
        } else {
            this.buffer.write(59);
            this.writeRawInteger(index);
        }
    }

    private void writeIVar(IVar<?> ivar) throws IOException {
        if (!this.writeObjectReference(ivar)) {
            this.buffer.write(73);
            this.writeObject(ivar.getInstance());
            this.writeRawMap((Map)ivar.getData());
        }
    }

    private void writeRawMap(Map<Symbol, Object> map) throws IOException {
        this.writeRawInteger(map.size());
        for (Map.Entry<Symbol, Object> entry : map.entrySet()) {
            this.writeObject(entry.getKey());
            this.writeObject(entry.getValue());
        }
    }

    private boolean writeObjectReference(Object object) {
        int index = this.cache.indexOf(object);
        if (index == -1) {
            this.cache.add(object);
            return false;
        }
        this.buffer.write(64);
        this.writeRawInteger(index);
        return true;
    }

    static class BooleanVisitor
    implements DumpVisitor<Boolean> {
        BooleanVisitor() {
        }

        @Override
        public void accept(MarshalDump m, Boolean bool) {
            if (bool.booleanValue()) {
                m.buffer.write(84);
            } else {
                m.buffer.write(70);
            }
        }
    }

    static class BytesVisitor
    implements DumpVisitor<UserDefMarshaled<?>> {
        BytesVisitor() {
        }

        @Override
        public void accept(MarshalDump dump, UserDefMarshaled<?> obj) throws IOException {
            if (!dump.writeObjectReference(obj)) {
                dump.buffer.write(117);
                dump.writeSymbol(obj.className);
                dump.writeBytes((byte[])obj.marshalDump());
            }
        }
    }

    static interface DumpVisitor<T> {
        public void accept(MarshalDump var1, T var2) throws IOException;
    }

    static class IVarVisitor
    implements DumpVisitor<IVar<?>> {
        IVarVisitor() {
        }

        @Override
        public void accept(MarshalDump dump, IVar<?> ivar) throws IOException {
            dump.writeIVar(ivar);
        }
    }

    static class ListVisitor
    implements DumpVisitor<Collection<?>> {
        ListVisitor() {
        }

        @Override
        public void accept(MarshalDump dump, Collection<?> list) throws IOException {
            if (!dump.writeObjectReference(list)) {
                dump.buffer.write(91);
                dump.writeRawInteger(list.size());
                for (Object obj : list) {
                    dump.writeObject(obj);
                }
            }
        }
    }

    static class MapVisitor
    implements DumpVisitor<Map<Object, Object>> {
        MapVisitor() {
        }

        @Override
        public void accept(MarshalDump dump, Map<Object, Object> map) throws IOException {
            if (!dump.writeObjectReference(map)) {
                dump.buffer.write(123);
                dump.writeRawInteger(map.size());
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    dump.writeObject(entry.getKey());
                    dump.writeObject(entry.getValue());
                }
            }
        }
    }

    static class NumberVisitor
    implements DumpVisitor<Number> {
        NumberVisitor() {
        }

        @Override
        public void accept(MarshalDump m, Number val) {
            m.buffer.write(105);
            m.writeRawInteger(val.longValue());
        }
    }

    static class RawStringVisitor
    implements DumpVisitor<RawString> {
        RawStringVisitor() {
        }

        @Override
        public void accept(MarshalDump dump, RawString string) throws IOException {
            if (!dump.writeObjectReference(string)) {
                dump.buffer.write(34);
                dump.writeBytes(string.getBytes());
            }
        }
    }

    static class RubyObjectVisitor
    implements DumpVisitor<RubyObject> {
        RubyObjectVisitor() {
        }

        @Override
        public void accept(MarshalDump dump, RubyObject obj) throws IOException {
            if (!dump.writeObjectReference(obj)) {
                dump.buffer.write(111);
                dump.writeSymbol(obj.className);
                dump.writeRawMap((Map)obj.getData());
            }
        }
    }

    static class RubyObjectWrapperVisitor
    implements DumpVisitor<Marshaled<?>> {
        RubyObjectWrapperVisitor() {
        }

        @Override
        public void accept(MarshalDump dump, Marshaled<?> wrappedObj) throws IOException {
            Object obj = wrappedObj.marshalDump();
            dump.writeObject(obj);
        }
    }

    static class StringVisitor
    implements DumpVisitor<String> {
        StringVisitor() {
        }

        @Override
        public void accept(MarshalDump dump, String string) throws IOException {
            IVar<RawString> ivar = new IVar<RawString>(new RawString(string));
            ivar.put(Symbol.create("E"), Boolean.TRUE);
            dump.writeIVar(ivar);
        }
    }

    static class SymbolVisitor
    implements DumpVisitor<Symbol> {
        SymbolVisitor() {
        }

        @Override
        public void accept(MarshalDump m, Symbol sym) throws IOException {
            m.writeSymbol(sym);
        }
    }

    static class UserMarshaledVisitor
    implements DumpVisitor<UserMarshaled<?>> {
        UserMarshaledVisitor() {
        }

        @Override
        public void accept(MarshalDump dump, UserMarshaled<?> obj) throws IOException {
            if (!dump.writeObjectReference(obj)) {
                dump.buffer.write(85);
                dump.writeSymbol(obj.className);
                dump.writeObject(obj.marshalDump());
            }
        }
    }
}

