/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.internal.YamlParser;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;

public class GemSpecificationUtils {
    public static final String METADATA_GZ = "metadata.gz";
    private static final YamlParser yaml = new YamlParser();

    private GemSpecificationUtils() {
    }

    public static GemSpecification retrieveGemSpecification(InputStreamSupplier streamOfGem) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TarArchiveInputStream tar = new TarArchiveInputStream(streamOfGem.get());){
            TarArchiveEntry entry = tar.getNextTarEntry();
            while (entry != null && !METADATA_GZ.equals(entry.getName())) {
                entry = tar.getNextTarEntry();
            }
            if (entry == null || !METADATA_GZ.equals(entry.getName())) {
                throw new IOException("not found in tar-archive: metadata.gz");
            }
            GZIPInputStream gis = new GZIPInputStream((InputStream)tar);
            Map<String, Object> yamlGemspec = yaml.load(gis);
            return new GemSpecification(yamlGemspec);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map<String, Object> getGemSpecificationAttributes(GemSpecification gemspec) {
        HashMap<String, Object> formatAttributes = new HashMap<String, Object>();
        formatAttributes.put("description", gemspec.getDescription());
        formatAttributes.put("summary", gemspec.getSummary());
        formatAttributes.put("homepage", gemspec.getHomepage());
        formatAttributes.put("licenses", gemspec.getLicenses());
        formatAttributes.put("emails", gemspec.getEmails());
        formatAttributes.put("authors", gemspec.getAuthors());
        formatAttributes.put("requirements", gemspec.getRequirements());
        formatAttributes.put("executables", gemspec.getExecutables());
        formatAttributes.put("created at", gemspec.getDate() == null ? null : gemspec.getDate().formatted());
        formatAttributes.put("required ruby version", gemspec.getRequiredRubyVersion().display());
        formatAttributes.put("required rubygems version", gemspec.getRequiredRubygemsVersion().display());
        GemCoordinate coordinate = Objects.requireNonNull(gemspec.getCoordinate());
        formatAttributes.put("platform", coordinate.getPlatform());
        return formatAttributes;
    }
}

