/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.google.common.base.Preconditions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;

public class RubygemsFileMatcher
extends ComponentSupport
implements Matcher {
    public boolean matches(Context context) {
        RubygemsFile file;
        Preconditions.checkNotNull((Object)context);
        String gems = context.getRequest().getParameters().get("gems");
        String path = context.getRequest().getPath();
        this.log.trace("rubygems file path {} ~ gems {}", (Object)path, (Object)gems);
        String[] gemList = null;
        if (gems != null) {
            gemList = gems.length() == 0 ? new String[]{} : gems.split(", ?");
        }
        if ((file = RubygemsFile.create(path, gemList)) == null) {
            return false;
        }
        this.log.debug("rubygems file {}", (Object)file);
        context.getAttributes().set(RubygemsFile.class, (Object)file);
        return true;
    }
}

