/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.RecipeSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.recipe.RouterBuilder;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsComponentMaintenanceImpl;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsContentFacetImpl;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsContentHandler;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsLastDownloadedHandler;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsFileMatcher;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsSecurityFacet;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;

@Named(value="rubygems-hosted")
@Singleton
public class RubygemsHostedRecipe
extends RecipeSupport {
    public static final String NAME = "rubygems-hosted";
    @Inject
    Provider<RubygemsSecurityFacet> securityFacet;
    @Inject
    Provider<ConfigurableViewFacet> viewFacet;
    @Inject
    Provider<RubygemsContentFacetImpl> rubygemsContentFacet;
    @Inject
    Provider<RubygemsComponentMaintenanceImpl> componentMaintenance;
    @Inject
    Provider<SearchFacet> searchFacet;
    @Inject
    Provider<BrowseFacet> browseFacet;
    @Inject
    ExceptionHandler exceptionHandler;
    @Inject
    TimingHandler timingHandler;
    @Inject
    SecurityHandler securityHandler;
    @Inject
    PartialFetchHandler partialFetchHandler;
    @Inject
    RubygemsContentHandler rubygemsContentHandler;
    @Inject
    ConditionalRequestHandler conditionalRequestHandler;
    @Inject
    ContentHeadersHandler contentHeadersHandler;
    @Inject
    HandlerContributor handlerContributor;
    @Inject
    RubygemsLastDownloadedHandler lastDownloadedHandler;

    @Inject
    public RubygemsHostedRecipe(@Named(value="hosted") Type type, @Named(value="rubygems") Format format) {
        super(type, format);
    }

    public void apply(@Nonnull Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.rubygemsContentFacet.get());
        repository.attach((Facet)this.componentMaintenance.get());
        repository.attach((Facet)this.browseFacet.get());
        repository.attach((Facet)this.searchFacet.get());
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        this.addBrowseUnsupportedRoute((RouterBuilder)builder);
        builder.route(new Route.Builder().matcher((Matcher)new RubygemsFileMatcher()).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.partialFetchHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.rubygemsContentHandler).create());
        builder.defaultHandlers(new Handler[]{HttpHandlers.badRequest()});
        facet.configure(builder.create());
        return facet;
    }
}

