/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.RecipeSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.recipe.RouterBuilder;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsGroupFacet;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsGroupHandler;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsFileMatcher;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsSecurityFacet;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;

@Named(value="rubygems-group")
@Singleton
public class RubygemsGroupRecipe
extends RecipeSupport {
    public static final String NAME = "rubygems-group";
    @Inject
    Provider<ConfigurableViewFacet> viewFacet;
    @Inject
    Provider<RubygemsGroupFacet> groupFacet;
    @Inject
    Provider<RubygemsSecurityFacet> securityFacet;
    @Inject
    Provider<RubygemsContentFacet> contentFacet;
    @Inject
    RubygemsGroupHandler groupHandler;
    @Inject
    ContentHeadersHandler contentHeadersHandler;
    @Inject
    ConditionalRequestHandler conditionalRequestHandler;
    @Inject
    HandlerContributor handlerContributor;
    @Inject
    ExceptionHandler exceptionHandler;
    @Inject
    SecurityHandler securityHandler;
    @Inject
    TimingHandler timingHandler;

    @Inject
    public RubygemsGroupRecipe(@Named(value="group") Type type, @Named(value="rubygems") Format format) {
        super(type, format);
    }

    public void apply(@Nonnull Repository repository) throws Exception {
        repository.attach((Facet)this.contentFacet.get());
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.groupFacet.get());
    }

    private ViewFacet configure(ConfigurableViewFacet viewFacet) {
        Router.Builder builder = new Router.Builder();
        this.addBrowseUnsupportedRoute((RouterBuilder)builder);
        builder.route(new Route.Builder().matcher((Matcher)new RubygemsFileMatcher()).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.groupHandler).create());
        builder.defaultHandlers(new Handler[]{HttpHandlers.badRequest()});
        viewFacet.configure(builder.create());
        return viewFacet;
    }
}

