/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.datastore.internal.BundlerContentApiUtils;
import org.sonatype.nexus.repository.rubygems.datastore.internal.GzipContentWrapper;
import org.sonatype.nexus.repository.rubygems.datastore.internal.RubygemsGroupFacet;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Named
@Singleton
public class RubygemsGroupHandler
extends GroupHandler {
    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        GzipContentWrapper content;
        RubygemsFile file = (RubygemsFile)((Object)context.getAttributes().require(RubygemsFile.class));
        Repository repository = context.getRepository();
        this.log.debug("group repository: {} file: {}", (Object)repository.getName(), (Object)file);
        switch (file.getKind()) {
            case GEM: 
            case GEMSPEC: {
                return super.doGet(context, dispatched);
            }
            case SPECS_INDEX: {
                Content specsIndex = this.handleSpecsIndex(context, dispatched, file);
                content = new GzipContentWrapper(specsIndex);
                break;
            }
            case BUNDLER_API_DEPENDENCIES: {
                if (file.getGems() != null && file.getGems().isEmpty()) {
                    content = new Content((Payload)BundlerContentApiUtils.EMPTY_BUNDLER_GEMS_PAYLOAD);
                    break;
                }
                if (file.getGems() == null) {
                    content = new Content((Payload)BundlerContentApiUtils.EMPTY_PAYLOAD);
                    break;
                }
                content = this.handleBundlerApi(context, dispatched);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported asset kind " + (Object)((Object)file.getKind()));
            }
        }
        return HttpResponses.ok((Payload)content);
    }

    private Content handleBundlerApi(Context context, GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Map<Repository, Response> responses = this.getResponses(context, dispatched);
        BundlerGems result = new BundlerGems();
        for (Map.Entry<Repository, Response> entry : responses.entrySet()) {
            if (entry.getValue().getStatus().getCode() != 200) continue;
            Payload payload = entry.getValue().getPayload();
            Preconditions.checkNotNull((Object)payload);
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream is = payload.openInputStream();){
                result.addAll(Marshal.loadAs(is, BundlerGems.class).getGems());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return new Content((Payload)new BytesPayload(Marshal.dumpAsBytes(result), "application/octet-stream"));
    }

    private Content handleSpecsIndex(Context context, GroupHandler.DispatchedRepositories dispatched, RubygemsFile file) throws Exception {
        RubygemsGroupFacet facet = (RubygemsGroupFacet)context.getRepository().facet(RubygemsGroupFacet.class);
        Content content = facet.getCachedContent(file);
        DateTime lastModified = content != null && content.getAttributes().contains("last_modified") ? (DateTime)content.getAttributes().get("last_modified", DateTime.class) : null;
        Map<Repository, Response> responses = this.getResponses(context, dispatched);
        if (content == null || facet.isStale(lastModified, content, responses)) {
            return facet.mergeSpecsIndexes(file, responses);
        }
        return content;
    }

    private Map<Repository, Response> getResponses(Context context, GroupHandler.DispatchedRepositories dispatched) throws Exception {
        GroupFacet groupFacet = (GroupFacet)context.getRepository().facet(GroupFacet.class);
        return this.getAll(context, groupFacet.members(), dispatched);
    }
}

