/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.internal.GZippedTempStreamSupplier;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.rubygems.marshal.SpecsIndex;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class RubygemsGroupFacet
extends GroupFacetImpl {
    private Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 specsIndexCooperation;

    @Inject
    public RubygemsGroupFacet(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") Type groupType, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        super(repositoryManager, constraintViolationFactory, groupType, repositoryCacheInvalidationService);
    }

    @Inject
    protected void configureCooperation(Cooperation2Factory cooperationFactory, @Named(value="${nexus.specsIndex.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.specsIndex.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.specsIndex.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.specsIndex.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.cooperationBuilder = cooperationFactory.configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    @VisibleForTesting
    void buildCooperation() {
        if (this.cooperationBuilder != null) {
            this.specsIndexCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":specsIndex");
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.buildCooperation();
    }

    public boolean isStale(@Nullable DateTime cacheLastModified, Content content, Map<Repository, Response> responses) {
        if (cacheLastModified == null || this.isStale(content)) {
            return true;
        }
        for (Map.Entry<Repository, Response> entry : responses.entrySet()) {
            Content responseContent;
            DateTime remoteLastModified;
            if (entry.getValue().getStatus().getCode() != 200 || (remoteLastModified = (responseContent = (Content)entry.getValue().getPayload()) != null ? (DateTime)((Content)entry.getValue().getPayload()).getAttributes().get("last_modified", DateTime.class) : null) != null && !remoteLastModified.isAfter((ReadableInstant)cacheLastModified)) continue;
            this.log.debug("{} found stale content", (Object)entry.getKey().getName());
            return true;
        }
        return false;
    }

    private Content putSpecsIndex(String assetPath, InputStreamSupplier streamSupplier) throws IOException {
        String normalizeAssetPath = this.normalizeAssetPath(assetPath);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = ((RubygemsContentFacet)this.facet(RubygemsContentFacet.class)).ingest(streamSupplier);){
            return ((RubygemsContentFacet)this.facet(RubygemsContentFacet.class)).assets().path(normalizeAssetPath).kind(AssetKind.SPECS_INDEX.name()).blob(tempBlob).save().markAsCached(this.cacheController.current()).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putSpecsIndex(String assetPath, SpecsIndex specs) throws IOException {
        byte[] bytes = Marshal.dumpAsBytes(specs);
        Throwable throwable = null;
        Object var5_6 = null;
        try (GZippedTempStreamSupplier streamSupplier = new GZippedTempStreamSupplier(new ByteArrayInputStream(bytes));){
            return this.putSpecsIndex(assetPath, streamSupplier);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Content mergeSpecsIndexes(RubygemsFile file, Map<Repository, Response> responses) throws IOException {
        return (Content)this.specsIndexCooperation.on(() -> this.doMerge(file, responses)).checkFunction(() -> Optional.ofNullable(this.getCachedContent(file))).cooperate(file.getPath(), new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Content doMerge(RubygemsFile file, Map<Repository, Response> responses) throws IOException {
        if (responses.size() == 1) {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Payload payload = (Payload)Preconditions.checkNotNull((Object)responses.values().iterator().next().getPayload());){
                return this.putSpecsIndex(file.getPath(), () -> ((Payload)payload).openInputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        SpecsIndex result = new SpecsIndex();
        Iterator<Map.Entry<Repository, Response>> iterator = responses.entrySet().iterator();
        while (true) {
            Map.Entry<Repository, Response> entry;
            block23: {
                if (!iterator.hasNext()) {
                    if (!file.getPath().equals(RubygemsFile.LATEST_SPECS_4_8_GZ)) return this.putSpecsIndex(file.getPath(), result);
                    result = result.toLatest();
                    return this.putSpecsIndex(file.getPath(), result);
                }
                entry = iterator.next();
                if (entry.getValue().getStatus().getCode() != 200) continue;
                this.log.trace("start parsing {}", (Object)entry.getKey().getName());
                Throwable throwable = null;
                Object var7_13 = null;
                try {
                    Payload payload = (Payload)Preconditions.checkNotNull((Object)entry.getValue().getPayload());
                    try {
                        try (GZIPInputStream is = new GZIPInputStream(payload.openInputStream());){
                            Object load = Marshal.load(is);
                            result.merge((List)load);
                        }
                        if (payload == null) break block23;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (payload == null) throw throwable;
                        payload.close();
                        throw throwable;
                    }
                    payload.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            this.log.trace("stop parsing {}", (Object)entry.getKey().getName());
        }
    }

    @Nullable
    public Content getCachedContent(RubygemsFile file) {
        return ((RubygemsContentFacet)this.facet(RubygemsContentFacet.class)).get(file.getPath()).map(FluentAsset::download).orElse(null);
    }

    private String normalizeAssetPath(String assetPath) {
        return StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

