/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.datastore.internal.BundlerContentApiUtils;
import org.sonatype.nexus.repository.rubygems.datastore.internal.GemCoordinateUtils;
import org.sonatype.nexus.repository.rubygems.internal.BundlerGemsPayload;
import org.sonatype.nexus.repository.rubygems.internal.GZippedTempStreamSupplier;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGem;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.rubygems.marshal.SpecsIndex;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="rubygems")
public class RubygemsContentFacetImpl
extends ContentFacetSupport
implements RubygemsContentFacet {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = Collections.unmodifiableList(Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1));

    @Inject
    protected RubygemsContentFacetImpl(@Named(value="rubygems") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    @Override
    public TempBlob ingest(Payload payload) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = payload.openInputStream();){
            return this.ingest(() -> inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public TempBlob ingest(InputStreamSupplier streamSupplier) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = streamSupplier.get();){
            return this.blobs().ingest(inputStream, "application/octet-stream", HASH_ALGORITHMS);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void putGem(Optional<GemCoordinate> coordinate, Payload payload) throws IOException {
        this.log.trace("put gem {}", coordinate);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.ingest(payload);){
            GemSpecification gemspec = GemSpecificationUtils.retrieveGemSpecification((InputStreamSupplier)tempBlob);
            if (coordinate.isPresent() && !coordinate.get().equals(gemspec.getCoordinate())) {
                throw new IllegalArgumentException("filename and gemname from gem do not match");
            }
            this.putGem(gemspec, tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public FluentAsset putGem(GemSpecification specification, TempBlob tempBlob) throws IOException {
        GemCoordinate coordinate = Objects.requireNonNull(specification.getCoordinate());
        FluentComponent component = this.getOrCreateGemComponent(coordinate);
        this.addToSpecsIndex(coordinate);
        this.addToBundlerApi(specification);
        this.updateGemspec(component, specification);
        return this.updateOrCreateGemAsset(component, specification, tempBlob);
    }

    @Override
    public FluentAsset putGemWithHardlink(GemSpecification specification, Blob assetBlob, Map<HashAlgorithm, HashCode> checksums) throws IOException {
        GemCoordinate coordinate = Objects.requireNonNull(specification.getCoordinate());
        FluentComponent component = this.getOrCreateGemComponent(coordinate);
        this.addToSpecsIndex(coordinate);
        this.addToBundlerApi(specification);
        this.updateGemspec(component, specification);
        return this.updateOrCreateGemAssetWithHardlink(component, specification, assetBlob, checksums);
    }

    @Override
    public Content getBundlerApiDependencies(List<String> gems) throws IOException {
        Objects.requireNonNull(gems);
        BundlerGems result = new BundlerGems();
        ArrayList<FluentAsset> assets = new ArrayList<FluentAsset>();
        for (String gem : gems) {
            this.log.trace("load dependencies for {}", (Object)gem);
            Optional<FluentAsset> asset = this.findBundlerApiDependencies(gem);
            if (!asset.isPresent()) continue;
            BundlerGems oneGem = BundlerContentApiUtils.asBundlerGems(asset.get());
            result.addAll(oneGem.getGems());
            assets.add(asset.get());
        }
        Content content = new Content((Payload)new BundlerGemsPayload(result));
        content.getAttributes().set("assetList", assets);
        return content;
    }

    @Override
    public Set<String> deleteGem(String assetPath) throws IOException {
        Optional<FluentAsset> rubygemsAsset = this.get(assetPath);
        if (!rubygemsAsset.isPresent()) {
            return Collections.emptySet();
        }
        FluentAsset asset = rubygemsAsset.get();
        if (!asset.kind().equals(AssetKind.GEM.name())) {
            this.log.trace("Did not delete: {}", (Object)asset);
            return Collections.emptySet();
        }
        Optional component = asset.component();
        if (component.isPresent()) {
            GemCoordinate coordinate = GemCoordinateUtils.toGemCoordinate((Component)component.get(), asset);
            this.deleteFromSpecsIndex(coordinate);
            this.deleteFromBundlerApi(coordinate);
            ImmutableSet.Builder deletedPaths = ImmutableSet.builder();
            FluentComponent componentToDelete = this.components().with((Component)component.get());
            componentToDelete.assets().forEach(assetToDelete -> {
                if (assetToDelete.delete()) {
                    deletedPaths.add((Object)assetToDelete.path());
                }
            });
            componentToDelete.delete();
            return deletedPaths.build();
        }
        return Collections.emptySet();
    }

    @Override
    public Optional<FluentAsset> get(String path) {
        return this.assets().path(RubygemsContentFacetImpl.assetPath(path)).find();
    }

    @Override
    public FluentAsset restoreGem(String path, GemCoordinate gemCoordinate, Payload payload) throws IOException {
        Optional<FluentAsset> gem = this.get(path);
        if (!gem.isPresent()) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
                GemSpecification gemspec = GemSpecificationUtils.retrieveGemSpecification((InputStreamSupplier)tempBlob);
                gem = Optional.of(this.updateOrCreateGemAsset(this.getOrCreateGemComponent(gemCoordinate), gemspec, tempBlob));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return gem.get();
    }

    @Override
    public FluentAsset restoreAsset(String path, AssetKind assetKind, Payload payload) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            Optional fluentAsset = this.assets().path(RubygemsContentFacetImpl.assetPath(path)).find();
            return fluentAsset.orElseGet(() -> this.assets().path(path).kind(assetKind.name()).blob(tempBlob).save());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Optional<FluentAsset> findBundlerApiDependencies(String name) {
        return this.get(GemCoordinate.dependenciesPath(name));
    }

    @Override
    public FluentAsset getCachedOrNewSpecsIndex(String path) throws IOException {
        Optional<FluentAsset> cachedSpecsIndex = this.get(path);
        if (cachedSpecsIndex.isPresent()) {
            return cachedSpecsIndex.get();
        }
        FluentAsset asset = this.createAsset(RubygemsContentFacetImpl.assetPath(path), AssetKind.SPECS_INDEX.name());
        return this.updateSpecsIndex(asset, new SpecsIndex());
    }

    @Override
    public FluentAsset updateOrCreateGemAsset(FluentComponent component, GemSpecification gemSpecification, TempBlob tempBlob) {
        return this.prepareGemFluentAsset(component, gemSpecification).blob(tempBlob).save();
    }

    @Override
    public FluentAsset updateOrCreateGemAssetWithHardlink(FluentComponent component, GemSpecification gemSpecification, Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        return this.prepareGemFluentAsset(component, gemSpecification).blob(blob, checksums).save();
    }

    private FluentAssetBuilder prepareGemFluentAsset(FluentComponent component, GemSpecification gemSpecification) {
        GemCoordinate coordinate = Objects.requireNonNull(gemSpecification.getCoordinate());
        String path = RubygemsContentFacetImpl.assetPath(coordinate.gemPath());
        return this.assets().path(path).kind(AssetKind.GEM.name()).component((Component)component).attributes("rubygems", GemSpecificationUtils.getGemSpecificationAttributes(gemSpecification));
    }

    @Override
    public FluentComponent getOrCreateGemComponent(GemCoordinate coordinate) {
        Preconditions.checkNotNull((Object)coordinate);
        return this.components().name(coordinate.getName()).version(coordinate.getVersion()).getOrCreate();
    }

    @Override
    public FluentAsset getOrCreateGemspecAsset(FluentComponent component, GemCoordinate coordinate) {
        String gemspecName = coordinate.gemspecPath();
        Optional<FluentAsset> getGemAsset = this.get(gemspecName);
        if (!getGemAsset.isPresent()) {
            FluentAsset asset = this.createAsset(RubygemsContentFacetImpl.assetPath(gemspecName), AssetKind.GEMSPEC.name(), component);
            this.log.trace("Created asset: {}", (Object)gemspecName);
            HashMap<String, String> formatAttributes = new HashMap<String, String>();
            formatAttributes.put("platform", coordinate.getPlatform());
            asset.withAttribute("rubygems", formatAttributes);
            return asset;
        }
        return getGemAsset.get();
    }

    @Override
    public FluentAsset getBundlerGemAsset(String path) {
        Optional<FluentAsset> asset = this.get(RubygemsContentFacetImpl.assetPath(path));
        return asset.orElseGet(() -> this.assets().path(RubygemsContentFacetImpl.assetPath(path)).kind(AssetKind.BUNDLER_API_DEPENDENCIES.name()).save());
    }

    @Override
    public FluentAsset getSpecsIndexAsset(RubygemsFile file, TempBlob tempBlob) {
        String assetPath = RubygemsContentFacetImpl.assetPath(file.getPath());
        Optional<FluentAsset> asset = this.get(assetPath);
        return asset.orElseGet(() -> this.assets().path(assetPath).kind(AssetKind.SPECS_INDEX.name()).blob(tempBlob).save());
    }

    protected WritePolicy writePolicy(Asset asset) {
        WritePolicy writePolicy = super.writePolicy(asset);
        if (writePolicy == WritePolicy.ALLOW_ONCE) {
            String assetKind = asset.kind();
            if (Objects.equals(AssetKind.SPECS_INDEX.name(), assetKind) || Objects.equals(AssetKind.BUNDLER_API_DEPENDENCIES.name(), assetKind)) {
                return WritePolicy.ALLOW;
            }
        }
        return writePolicy;
    }

    private FluentAsset createAsset(String path, String assetKind) {
        return this.assets().path(path).kind(assetKind).save();
    }

    private FluentAsset createAsset(String path, String assetKind, FluentComponent component) {
        FluentAssetBuilder assetBuilder = this.assets().path(path).kind(assetKind).component((Component)component);
        return assetBuilder.save();
    }

    @Override
    public FluentAsset updateAsset(FluentAsset asset, Payload payload) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            return asset.attach(tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void addToSpecsIndex(GemCoordinate coordinate) throws IOException {
        this.log.trace("Adding {} to specs-index", (Object)coordinate);
        String path = coordinate.isPrereleaseGem() ? RubygemsFile.PRERELEASE_SPECS_4_8_GZ : RubygemsFile.SPECS_4_8_GZ;
        FluentAsset asset = this.get(path).orElseGet(() -> this.createAsset(RubygemsContentFacetImpl.assetPath(path), AssetKind.SPECS_INDEX.name()));
        SpecsIndex index = RubygemsContentFacetImpl.asSpecsIndex(asset);
        index.add(coordinate);
        this.updateSpecsIndex(asset, index);
        if (!coordinate.isPrereleaseGem()) {
            this.updateLatestSpecsIndex(index);
        }
    }

    private void deleteFromSpecsIndex(GemCoordinate coordinate) throws IOException {
        this.log.trace("Deleting {} to specs-index", (Object)coordinate);
        String path = coordinate.isPrereleaseGem() ? RubygemsFile.PRERELEASE_SPECS_4_8_GZ : RubygemsFile.SPECS_4_8_GZ;
        Optional<FluentAsset> specIndex = this.get(path);
        if (specIndex.isPresent()) {
            FluentAsset asset = specIndex.get();
            SpecsIndex index = RubygemsContentFacetImpl.asSpecsIndex(asset);
            index.remove(coordinate);
            this.updateSpecsIndex(asset, index);
            if (!coordinate.isPrereleaseGem()) {
                this.updateLatestSpecsIndex(index);
            }
        }
    }

    private FluentAsset updateSpecsIndex(FluentAsset specs, SpecsIndex index) throws IOException {
        InputStream inputStream = Marshal.dumpAsInputStream(index);
        Throwable throwable = null;
        Object var5_6 = null;
        try (GZippedTempStreamSupplier streamSupplier = new GZippedTempStreamSupplier(inputStream);){
            return this.updateAsset(specs, (Payload)new StreamPayload((InputStreamSupplier)streamSupplier, (long)inputStream.available(), "application/octet-stream"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void deleteFromBundlerApi(GemCoordinate coordinate) throws IOException {
        FluentAsset asset = this.getBundlerApiDependencies(coordinate.getName());
        BundlerGems gems = BundlerContentApiUtils.asBundlerGems(asset);
        gems.remove(new BundlerGem(coordinate));
        this.updateBundlerGems(asset, gems);
    }

    private static SpecsIndex asSpecsIndex(FluentAsset asset) throws IOException {
        if (!asset.hasBlob()) {
            return new SpecsIndex();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (GZIPInputStream is = new GZIPInputStream(asset.download().openInputStream());){
            return Marshal.loadAs(is, SpecsIndex.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateLatestSpecsIndex(SpecsIndex index) throws IOException {
        Optional<FluentAsset> latest = this.get(RubygemsContentFacetImpl.assetPath(RubygemsFile.LATEST_SPECS_4_8_GZ));
        FluentAsset asset = latest.isPresent() ? latest.get() : this.createAsset(RubygemsContentFacetImpl.assetPath(RubygemsFile.LATEST_SPECS_4_8_GZ), AssetKind.SPECS_INDEX.name());
        this.updateSpecsIndex(asset, index.toLatest());
    }

    @Override
    public void addToBundlerApi(GemSpecification gemspec) throws IOException {
        FluentAsset asset = this.getBundlerApiDependencies(gemspec.getName());
        BundlerGems gems = BundlerContentApiUtils.asBundlerGems(asset);
        gems.add(new BundlerGem(gemspec));
        this.updateBundlerGems(asset, gems);
    }

    private void updateGemspec(FluentComponent component, GemSpecification gemspec) throws IOException {
        FluentAsset asset = this.getOrCreateGemspecAsset(component, Objects.requireNonNull(gemspec.getCoordinate()));
        byte[] bytes = Marshal.dumpAsBytes(gemspec);
        this.updateAsset(asset, (Payload)new StreamPayload(() -> new DeflaterInputStream(new ByteArrayInputStream(bytes)), (long)bytes.length, "application/octet-stream"));
    }

    private FluentAsset getBundlerApiDependencies(String name) {
        Optional<FluentAsset> asset = this.findBundlerApiDependencies(name);
        if (asset.isPresent()) {
            return asset.get();
        }
        return this.createAsset(RubygemsContentFacetImpl.assetPath(GemCoordinate.dependenciesPath(name)), AssetKind.BUNDLER_API_DEPENDENCIES.name());
    }

    private void updateBundlerGems(FluentAsset asset, BundlerGems gems) throws IOException {
        if (gems.getGems().isEmpty()) {
            asset.delete();
        } else {
            byte[] bytes = Marshal.dumpAsBytes(gems);
            this.updateAsset(asset, (Payload)new StreamPayload(() -> new ByteArrayInputStream(bytes), (long)bytes.length, "application/octet-stream"));
        }
    }

    private static String assetPath(String assetPath) {
        return StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

