/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.DefaultMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;

@Named
public class RubygemsComponentMaintenanceImpl
extends DefaultMaintenanceFacet {
    public Set<String> deleteAsset(Asset asset) {
        FluentAsset assetToDelete = this.contentFacet().assets().with(asset);
        RubygemsContentFacet facet = (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
        if (!AssetKind.GEM.name().equals(assetToDelete.kind())) {
            return Collections.emptySet();
        }
        try {
            return facet.deleteGem(assetToDelete.path());
        }
        catch (IOException e) {
            this.log.error("error deleting asset {} from repository {}", new Object[]{asset.path(), this.getRepository().getName(), e});
            return Collections.emptySet();
        }
    }

    public Set<String> deleteComponent(Component component) {
        FluentComponent componentToDelete = this.contentFacet().components().with(component);
        Collection assets = componentToDelete.assets();
        Optional<FluentAsset> gemAsset = assets.stream().filter(it -> AssetKind.GEM.name().equals(it.kind())).findFirst();
        if (gemAsset.isPresent()) {
            RubygemsContentFacet facet = (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
            try {
                return facet.deleteGem(gemAsset.get().path());
            }
            catch (IOException e) {
                this.log.error("error deleting component {} with version {} from repository {}", new Object[]{component.name(), component.version(), this.getRepository().getName(), e});
            }
        }
        return Collections.emptySet();
    }

    public int deleteComponents(int[] componentIds) {
        return (int)Arrays.stream(componentIds).boxed().map(InternalIds::toExternalId).map(componentId -> ((ContentFacet)this.getRepository().facet(ContentFacet.class)).components().find(componentId)).filter(Optional::isPresent).map(Optional::get).map(this::deleteComponent).count();
    }
}

