/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.rubygems.internal.BundlerGemsPayload;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

public class BundlerContentApiUtils {
    static final BytesPayload EMPTY_PAYLOAD = new BytesPayload(new byte[0], "application/octet-stream");
    static final BundlerGemsPayload EMPTY_BUNDLER_GEMS_PAYLOAD = new BundlerGemsPayload(BundlerGems.EMPTY);

    private BundlerContentApiUtils() {
    }

    public static BundlerGems asBundlerGems(FluentAsset asset) throws IOException {
        Preconditions.checkNotNull((Object)asset);
        if (!asset.hasBlob()) {
            return new BundlerGems();
        }
        return BundlerContentApiUtils.asBundlerGems((Payload)asset.download());
    }

    public static BundlerGems asBundlerGems(Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)payload);
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = payload.openInputStream();){
            return Marshal.loadAs(is, BundlerGems.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

