/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.datastore;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.RubygemsRepairMetadata;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.internal.utils.GemSpecificationUtils;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;

@Named
@Singleton
public class RubygemsRepairMetadataImpl
extends ComponentSupport
implements RubygemsRepairMetadata {
    private static final int BATCH_SIZE = 100;
    private static final List<String> SPECS_LIST = Arrays.asList(RubygemsFile.SPECS_4_8_GZ, RubygemsFile.PRERELEASE_SPECS_4_8_GZ, RubygemsFile.LATEST_SPECS_4_8_GZ);
    private final Type hostedType;
    private final Format format;

    @Inject
    public RubygemsRepairMetadataImpl(@Named(value="hosted") Type hostedType, @Named(value="rubygems") Format format) {
        this.hostedType = (Type)Preconditions.checkNotNull((Object)hostedType);
        this.format = (Format)Preconditions.checkNotNull((Object)format);
    }

    private boolean isHostedRubygemsRepository(Repository repository) {
        return repository.getFormat().equals((Object)this.format) && repository.getType().equals((Object)this.hostedType);
    }

    @Override
    public void repairRepository(Repository repository) {
        if (this.isHostedRubygemsRepository(repository)) {
            this.recreateSpecsIndexes(repository);
            this.doRepairRepository(repository);
        } else {
            this.log.info("Not repairing a proxy repository {}", (Object)repository.getName());
        }
    }

    private void recreateSpecsIndexes(Repository repository) {
        RubygemsContentFacet facet = (RubygemsContentFacet)repository.facet(RubygemsContentFacet.class);
        for (String path : SPECS_LIST) {
            Optional<FluentAsset> specAsset = facet.get(path);
            specAsset.ifPresent(FluentAsset::delete);
            try {
                facet.getCachedOrNewSpecsIndex(path);
            }
            catch (IOException iOException) {
                this.log.error("Unable to recreate specs index file for repository {}", (Object)repository);
            }
        }
    }

    private void doRepairRepository(Repository repository) {
        RubygemsContentFacet facet = (RubygemsContentFacet)repository.facet(RubygemsContentFacet.class);
        Continuation gems = facet.assets().byKind(AssetKind.GEM.name()).browse(100, null);
        while (!gems.isEmpty()) {
            for (FluentAsset gem : gems) {
                try {
                    GemSpecification gemspec = GemSpecificationUtils.retrieveGemSpecification(() -> gem.download().openInputStream());
                    GemCoordinate coordinate = Objects.requireNonNull(gemspec.getCoordinate());
                    facet.addToSpecsIndex(coordinate);
                    facet.addToBundlerApi(gemspec);
                }
                catch (IOException e) {
                    this.log.error("Unable to add {} from repository {} to specs index", new Object[]{gem.path(), repository, e});
                }
            }
            gems = facet.assets().byKind(AssetKind.GEM.name()).browse(100, gems.nextContinuationToken());
        }
    }
}

