/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems;

import com.google.common.base.Preconditions;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;

public class RubygemsFile
extends ComponentSupport
implements GroovyObject {
    public static final String INTERNAL_DEPENDENCIES = "dependencies";
    public static final String API_V1_DEPENDENCIES = "api/v1/dependencies";
    public static final String API_V1_GEMS = "api/v1/gems";
    public static final String GEMS = "gems";
    public static final String GEM_SUFFIX = ".gem";
    public static final String SPECS_4_8 = "specs.4.8";
    public static final String SPECS_4_8_GZ;
    public static final String LATEST_SPECS_4_8_GZ;
    public static final String PRERELEASE_SPECS_4_8_GZ;
    public static final String API_PREFIX = "api/";
    public static final String GZ_SUFFIX = ".gz";
    public static final String RUBY_SUFFIX = ".ruby";
    private final GemCoordinate coordinate;
    private final AssetKind kind;
    private final String path;
    private final List<String> gems;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    private RubygemsFile(GemCoordinate coordinate, AssetKind kind, String path, String ... gems) {
        MetaClass metaClass;
        CallSite[] callSiteArray = RubygemsFile.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        GemCoordinate gemCoordinate = coordinate;
        this.coordinate = (GemCoordinate)ScriptBytecodeAdapter.castToType((Object)gemCoordinate, GemCoordinate.class);
        AssetKind assetKind = kind;
        this.kind = (AssetKind)ShortTypeHandling.castToEnum((Object)((Object)assetKind), AssetKind.class);
        String string = path;
        this.path = ShortTypeHandling.castToString((Object)string);
        String[] stringArray = gems;
        this.gems = (List)ScriptBytecodeAdapter.castToType((Object)stringArray, List.class);
    }

    public static RubygemsFile create(String path, String ... gems) {
        CallSite[] callSiteArray = RubygemsFile.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)path, (Object)"/"))) {
            Object object = callSiteArray[1].call((Object)path, (Object)1);
            path = ShortTypeHandling.castToString((Object)object);
        }
        GemCoordinate coordinate = (GemCoordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(GemCoordinate.class, (Object)path), GemCoordinate.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)coordinate, null)) {
                callSiteArray[3].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)gems, null), (Object)"Expected the list of gems for path %s to be null, but was %s", (Object)path, callSiteArray[4].call((Object)gems));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)path, (Object)GEM_SUFFIX))) {
                    return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callConstructor(RubygemsFile.class, (Object)coordinate, callSiteArray[7].callGetProperty(AssetKind.class), callSiteArray[8].call((Object)coordinate), null), RubygemsFile.class));
                }
                return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callConstructor(RubygemsFile.class, (Object)coordinate, callSiteArray[10].callGetProperty(AssetKind.class), callSiteArray[11].call((Object)coordinate), null), RubygemsFile.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call((Object)API_V1_DEPENDENCIES, (Object)path)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)INTERNAL_DEPENDENCIES, (Object)path))) {
                return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callConstructor(RubygemsFile.class, null, callSiteArray[15].callGetProperty(AssetKind.class), (Object)path, (Object)gems), RubygemsFile.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call((Object)path, (Object)API_V1_DEPENDENCIES)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)path, (Object)RUBY_SUFFIX))) {
                return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].callStatic(RubygemsFile.class, (Object)path, (Object)API_V1_DEPENDENCIES), RubygemsFile.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call((Object)path, (Object)INTERNAL_DEPENDENCIES)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].call((Object)path, (Object)RUBY_SUFFIX))) {
                return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callStatic(RubygemsFile.class, (Object)path, (Object)INTERNAL_DEPENDENCIES), RubygemsFile.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call((Object)API_V1_GEMS, (Object)path))) {
                return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(RubygemsFile.class, null, callSiteArray[24].callGetProperty(AssetKind.class), (Object)path), RubygemsFile.class));
            }
        } else {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)coordinate, null)) {
                callSiteArray[25].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)gems, null), (Object)"Expected the list of gems for path %s to be null, but was %s", (Object)path, callSiteArray[26].call((Object)gems));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call((Object)path, (Object)GEM_SUFFIX))) {
                    return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].callConstructor(RubygemsFile.class, (Object)coordinate, callSiteArray[29].callGetProperty(AssetKind.class), callSiteArray[30].call((Object)coordinate), null), RubygemsFile.class));
                }
                return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callConstructor(RubygemsFile.class, (Object)coordinate, callSiteArray[32].callGetProperty(AssetKind.class), callSiteArray[33].call((Object)coordinate), null), RubygemsFile.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[34].call((Object)API_V1_DEPENDENCIES, (Object)path)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call((Object)INTERNAL_DEPENDENCIES, (Object)path))) {
                return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].callConstructor(RubygemsFile.class, null, callSiteArray[37].callGetProperty(AssetKind.class), (Object)path, (Object)gems), RubygemsFile.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].call((Object)path, (Object)API_V1_DEPENDENCIES)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call((Object)path, (Object)RUBY_SUFFIX))) {
                return RubygemsFile.getDependencyRubygemsFile(path, API_V1_DEPENDENCIES);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].call((Object)path, (Object)INTERNAL_DEPENDENCIES)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].call((Object)path, (Object)RUBY_SUFFIX))) {
                return RubygemsFile.getDependencyRubygemsFile(path, INTERNAL_DEPENDENCIES);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].call((Object)API_V1_GEMS, (Object)path))) {
                return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].callConstructor(RubygemsFile.class, null, callSiteArray[44].callGetProperty(AssetKind.class), (Object)path), RubygemsFile.class));
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].call((Object)path, (Object)API_PREFIX))) {
            Object object = callSiteArray[46].call((Object)path, (Object)4);
            path = ShortTypeHandling.castToString((Object)object);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].call((Object)path, (Object)SPECS_4_8_GZ)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call((Object)path, (Object)LATEST_SPECS_4_8_GZ)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].call((Object)path, (Object)PRERELEASE_SPECS_4_8_GZ))) {
            return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callConstructor(RubygemsFile.class, null, callSiteArray[51].callGetProperty(AssetKind.class), (Object)path, null), RubygemsFile.class));
        }
        return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType(null, RubygemsFile.class));
    }

    private static RubygemsFile getDependencyRubygemsFile(String path, String prefix) {
        CallSite[] callSiteArray = RubygemsFile.$getCallSiteArray();
        String gem = ShortTypeHandling.castToString((Object)callSiteArray[52].call((Object)path, callSiteArray[53].call(callSiteArray[54].call((Object)prefix), (Object)1), callSiteArray[55].call((Object)path, (Object)RUBY_SUFFIX)));
        return (RubygemsFile)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callConstructor(RubygemsFile.class, null, callSiteArray[57].callGetProperty(AssetKind.class), (Object)prefix, (Object)gem), RubygemsFile.class));
    }

    @Nullable
    public GemCoordinate getCoordinate() {
        CallSite[] callSiteArray = RubygemsFile.$getCallSiteArray();
        return this.coordinate;
    }

    @Nonnull
    public AssetKind getKind() {
        CallSite[] callSiteArray = RubygemsFile.$getCallSiteArray();
        return this.kind;
    }

    @Nonnull
    public String getPath() {
        CallSite[] callSiteArray = RubygemsFile.$getCallSiteArray();
        return this.path;
    }

    @Nonnull
    public String getUrl() {
        CallSite[] callSiteArray = RubygemsFile.$getCallSiteArray();
        StringBuilder path = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callConstructor(StringBuilder.class, (Object)this.path), StringBuilder.class);
        if (ScriptBytecodeAdapter.compareNotEqual(this.gems, null)) {
            callSiteArray[59].call((Object)path, (Object)"?gems=");
            StringJoiner sj = (StringJoiner)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callConstructor(StringJoiner.class, (Object)","), StringJoiner.class);
            String gem = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].call(this.gems), Iterator.class);
            while (iterator.hasNext()) {
                gem = ShortTypeHandling.castToString(iterator.next());
                try {
                    callSiteArray[62].call((Object)sj, callSiteArray[63].call(URLEncoder.class, (Object)gem, (Object)"UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    callSiteArray[64].call(callSiteArray[65].callGroovyObjectGetProperty((Object)this), (Object)"Failed to encode gem string: {}", (Object)gem, (Object)e);
                    throw (Throwable)callSiteArray[66].callConstructor(RuntimeException.class, (Object)e);
                }
            }
            callSiteArray[67].call((Object)path, (Object)sj);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[68].call((Object)path));
    }

    @Nullable
    public List<String> getGems() {
        CallSite[] callSiteArray = RubygemsFile.$getCallSiteArray();
        return this.gems;
    }

    public String toString() {
        CallSite[] callSiteArray = RubygemsFile.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[69].call(callSiteArray[70].call(callSiteArray[71].call(callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call(callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].call(callSiteArray[78].call((Object)"RubygemsFile{", (Object)"coordinate="), (Object)this.coordinate), (Object)", kind="), (Object)this.kind), (Object)", path='"), (Object)this.path), (Object)"'"), (Object)", gems="), this.gems), (Object)"}"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != RubygemsFile.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = RubygemsFile.$getCallSiteArray()[79].call((Object)SPECS_4_8, (Object)GZ_SUFFIX);
        SPECS_4_8_GZ = ShortTypeHandling.castToString((Object)object);
        Object object2 = RubygemsFile.$getCallSiteArray()[80].call(RubygemsFile.$getCallSiteArray()[81].call((Object)"latest_", (Object)SPECS_4_8), (Object)GZ_SUFFIX);
        LATEST_SPECS_4_8_GZ = ShortTypeHandling.castToString((Object)object2);
        Object object3 = RubygemsFile.$getCallSiteArray()[82].call(RubygemsFile.$getCallSiteArray()[83].call((Object)"prerelease_", (Object)SPECS_4_8), (Object)GZ_SUFFIX);
        PRERELEASE_SPECS_4_8_GZ = ShortTypeHandling.castToString((Object)object3);
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "startsWith";
        stringArray[1] = "substring";
        stringArray[2] = "fromPath";
        stringArray[3] = "checkArgument";
        stringArray[4] = "toString";
        stringArray[5] = "endsWith";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "GEM";
        stringArray[8] = "gemPath";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "GEMSPEC";
        stringArray[11] = "gemspecPath";
        stringArray[12] = "equals";
        stringArray[13] = "equals";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "BUNDLER_API_DEPENDENCIES";
        stringArray[16] = "startsWith";
        stringArray[17] = "endsWith";
        stringArray[18] = "getDependencyRubygemsFile";
        stringArray[19] = "startsWith";
        stringArray[20] = "endsWith";
        stringArray[21] = "getDependencyRubygemsFile";
        stringArray[22] = "equals";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "GEM";
        stringArray[25] = "checkArgument";
        stringArray[26] = "toString";
        stringArray[27] = "endsWith";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "GEM";
        stringArray[30] = "gemPath";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "GEMSPEC";
        stringArray[33] = "gemspecPath";
        stringArray[34] = "equals";
        stringArray[35] = "equals";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "BUNDLER_API_DEPENDENCIES";
        stringArray[38] = "startsWith";
        stringArray[39] = "endsWith";
        stringArray[40] = "startsWith";
        stringArray[41] = "endsWith";
        stringArray[42] = "equals";
        stringArray[43] = "<$constructor$>";
        stringArray[44] = "GEM";
        stringArray[45] = "startsWith";
        stringArray[46] = "substring";
        stringArray[47] = "equals";
        stringArray[48] = "equals";
        stringArray[49] = "equals";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "SPECS_INDEX";
        stringArray[52] = "substring";
        stringArray[53] = "plus";
        stringArray[54] = "length";
        stringArray[55] = "lastIndexOf";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "BUNDLER_API_DEPENDENCIES";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "append";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "iterator";
        stringArray[62] = "add";
        stringArray[63] = "encode";
        stringArray[64] = "error";
        stringArray[65] = "log";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "append";
        stringArray[68] = "toString";
        stringArray[69] = "plus";
        stringArray[70] = "plus";
        stringArray[71] = "plus";
        stringArray[72] = "plus";
        stringArray[73] = "plus";
        stringArray[74] = "plus";
        stringArray[75] = "plus";
        stringArray[76] = "plus";
        stringArray[77] = "plus";
        stringArray[78] = "plus";
        stringArray[79] = "plus";
        stringArray[80] = "plus";
        stringArray[81] = "plus";
        stringArray[82] = "plus";
        stringArray[83] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[84];
        RubygemsFile.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RubygemsFile.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RubygemsFile.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

