/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsConstants;

public enum AssetKind {
    GEM(CacheControllerHolder.CONTENT, RubygemsConstants.GEMS_MATCHER),
    GEMSPEC(CacheControllerHolder.CONTENT, RubygemsConstants.GEMSPEC_MATCHER),
    BUNDLER_API_DEPENDENCIES(CacheControllerHolder.METADATA, RubygemsConstants.DEPENDENCIES_MATCHER),
    SPECS_INDEX(CacheControllerHolder.METADATA, RubygemsConstants.SPECS_MATCHER);

    private final CacheControllerHolder.CacheType cacheType;
    private final Pattern pattern;

    private AssetKind(CacheControllerHolder.CacheType cacheType, Pattern pattern) {
        this.cacheType = (CacheControllerHolder.CacheType)Preconditions.checkNotNull((Object)cacheType);
        this.pattern = pattern;
    }

    public static AssetKind matching(String name) {
        AssetKind[] assetKindArray = AssetKind.values();
        int n = assetKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            AssetKind assetKind = assetKindArray[n2];
            if (assetKind.pattern.matcher(name).matches()) {
                return assetKind;
            }
            ++n2;
        }
        throw new RuntimeException("Unable to find AssetKind from " + name);
    }

    @Nonnull
    public CacheControllerHolder.CacheType getCacheType() {
        return this.cacheType;
    }
}

