/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sonatype.nexus.exportimport.model.AssetFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class HttpPushRequestXO {
    @JsonProperty(value="type")
    public final Type type;
    @JsonProperty(value="assets")
    public final Map<String, Part> partMap;

    public HttpPushRequestXO() {
        this.type = Type.ADD;
        this.partMap = new HashMap<String, Part>();
    }

    public HttpPushRequestXO(Type type) {
        this.type = type;
        this.partMap = new HashMap<String, Part>();
    }

    @JsonIgnore
    public Set<String> getPartIDs() {
        return this.partMap.keySet();
    }

    @JsonIgnore
    public Part getPartMetadata(String partID) {
        return this.partMap.get(partID);
    }

    public String addPartMetadata(String repository, String format, String assetName, AssetFileAttributes attributes) {
        Part partMetadata = new Part(repository, format, assetName, attributes);
        String partID = UUID.randomUUID().toString();
        this.partMap.put(partID, partMetadata);
        return partID;
    }

    public static class Part {
        @JsonProperty(value="repository")
        public final String repository;
        @JsonProperty(value="format")
        public final String format;
        @JsonProperty(value="assetName")
        public final String assetName;
        public final AssetFileAttributes attributes;

        public Part() {
            this.repository = null;
            this.assetName = null;
            this.format = null;
            this.attributes = null;
        }

        public Part(String repository, String format, String assetName, AssetFileAttributes attributes) {
            this.repository = repository;
            this.format = format;
            this.assetName = assetName;
            this.attributes = attributes == null ? new AssetFileAttributes() : attributes;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getFormat() {
            return this.format;
        }

        public String getAssetName() {
            return this.assetName;
        }

        public AssetFileAttributes getAttributes() {
            return this.attributes;
        }
    }

    public static enum Type {
        ADD,
        DELETE;

    }
}

