/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.TargetInstanceConnector;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.rest.model.ReplicationRepositoryXO;
import com.sonatype.nexus.replication.rest.model.ReplicationTestRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.InvalidNameException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.rapture.PasswordPlaceholder;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.replication.ReplicationIngester;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.ssl.ApiCertificate;
import org.sonatype.nexus.ssl.CertificateRetriever;
import org.sonatype.nexus.ssl.KeystoreException;
import org.sonatype.nexus.ssl.TrustStore;

@Named
@Singleton
@Path(value="/internal/ui/replication")
public class ReplicationUIResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/internal/ui/replication";
    public static final String HOSTED_REPOSITORIES_PATH = "service/rest/internal/ui/replication/repositories";
    public static final String VALIDATE_COMPATIBILITY_PATH = "service/rest/internal/ui/replication/validate-compatibility";
    private final Set<String> supportedFormats;
    private final ReplicationConnectionManager replicationConnectionManager;
    private final TargetInstanceConnector targetInstanceConnector;
    private final ObjectMapper objectMapper;
    private final RepositoryManager repositoryManager;
    private final RepositoryPermissionChecker repositoryPermissionChecker;
    private final HostedType hosted;
    private final ApplicationVersion applicationVersion;
    private final CertificateRetriever certificateRetriever;
    private final TrustStore trustStore;

    @Inject
    public ReplicationUIResource(Map<String, ReplicationIngester> supportedFormatsReplicationIngesters, ReplicationConnectionManager replicationConnectionManager, TargetInstanceConnector targetInstanceConnector, RepositoryManager repositoryManager, RepositoryPermissionChecker repositoryPermissionChecker, HostedType hosted, @Named(value="repository-configuration") ObjectMapper objectMapper, ApplicationVersion applicationVersion, CertificateRetriever certificateRetriever, TrustStore trustStore) {
        this.supportedFormats = supportedFormatsReplicationIngesters.keySet();
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.targetInstanceConnector = (TargetInstanceConnector)Preconditions.checkNotNull((Object)targetInstanceConnector);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryPermissionChecker = (RepositoryPermissionChecker)Preconditions.checkNotNull((Object)repositoryPermissionChecker);
        this.hosted = (HostedType)Preconditions.checkNotNull((Object)hosted);
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
        this.certificateRetriever = certificateRetriever;
        this.trustStore = trustStore;
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:replication:read"})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="test-connection/")
    public List<ReplicationRepositoryXO> test(ReplicationTestRequest request) throws URISyntaxException {
        if (PasswordPlaceholder.is((String)request.getDestinationInstancePassword())) {
            ReplicationConnection replicationConnection = this.replicationConnectionManager.getByName(request.getName()).orElseThrow(InternalServerErrorException::new);
            request.setDestinationInstancePassword(replicationConnection.getDestinationInstancePassword());
        }
        return this.replicationTest(request.getDestinationInstanceUrl(), request.getDestinationInstanceUsername(), request.getDestinationInstancePassword(), request.isUseTrustStore(), request.getRepositoryFormat());
    }

    @RequiresAuthentication
    @GET
    @Path(value="validate-compatibility")
    @Produces(value={"application/json"})
    public void validateCompatibility(@QueryParam(value="version") String sourceVersion) {
        String targetVersion = this.applicationVersion.getVersion();
        if (!StringUtils.equals((CharSequence)sourceVersion, (CharSequence)targetVersion)) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, MessageFormat.format("Source version {0} does not match target version {1}", sourceVersion, targetVersion));
        }
    }

    @RequiresAuthentication
    @GET
    @Path(value="repositories")
    @Produces(value={"application/json"})
    public List<ReplicationRepositoryXO> getHostedRepositories(@QueryParam(value="repositoryFormat") String repositoryFormat) {
        List<ReplicationRepositoryXO> repositories = Streams.stream((Iterable)this.repositoryManager.browse()).filter(arg_0 -> ((RepositoryPermissionChecker)this.repositoryPermissionChecker).userCanReadOrBrowse(arg_0)).filter(repository -> repository.getType().equals((Object)this.hosted)).filter(repository -> this.supportedFormats.contains(repository.getFormat().toString())).filter(StringUtils.isNotEmpty((CharSequence)repositoryFormat) ? repository -> repository.getFormat().toString().equals(repositoryFormat) : repository -> true).map(repository -> new ReplicationRepositoryXO(repository.getName(), repository.getName(), repository.getFormat().toString())).sorted(Comparator.comparing(ReplicationRepositoryXO::getName)).collect(Collectors.toList());
        if (repositories.isEmpty()) {
            throw new WebApplicationMessageException(Response.Status.FORBIDDEN, "No browsable hosted repositories found");
        }
        return repositories;
    }

    @RequiresAuthentication
    @GET
    @Path(value="repository-format")
    @Produces(value={"application/json"})
    public String getRepositoryFormat(@QueryParam(value="repositoryName") String repositoryName) {
        return Streams.stream((Iterable)this.repositoryManager.browse()).filter(repository -> repository.getName().equals(repositoryName)).findFirst().orElseThrow(() -> new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, "")).getFormat().toString();
    }

    private List<ReplicationRepositoryXO> replicationTest(URI host, String username, String password, boolean useTrustStore, String repositoryFormat) {
        URI base = host.resolve(host.getPath().endsWith("/") ? host.getPath() : String.valueOf(host.getPath()) + "/");
        this.validateNexusCompatibility(username, password, useTrustStore, base);
        return this.getHostedRepositories(host, username, password, useTrustStore, base, repositoryFormat);
    }

    private List<ReplicationRepositoryXO> getHostedRepositories(URI host, String username, String password, boolean useTrustStore, URI base, String repositoryFormat) {
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (CloseableHttpClient client = this.targetInstanceConnector.createHttpClient(username, password, useTrustStore);){
                HttpGet hostedRepositoriesRequest = new HttpGet(base.resolve("service/rest/internal/ui/replication/repositories/?repositoryFormat=" + repositoryFormat));
                CloseableHttpResponse hostedRepositoriesResponse = client.execute((HttpUriRequest)hostedRepositoriesRequest);
                int statusCode = hostedRepositoriesResponse.getStatusLine().getStatusCode();
                hostedRepositoriesRequest.releaseConnection();
                if (statusCode == 200) {
                    return (List)this.objectMapper.readValue(hostedRepositoriesResponse.getEntity().getContent(), (TypeReference)new TypeReference<List<ReplicationRepositoryXO>>(){});
                }
                this.log.debug("Testing replication connection to host=\"{}\" with user=\"{}\" failed with status={}", new Object[]{host, username, statusCode});
                throw new WebApplicationMessageException(Response.Status.fromStatusCode((int)statusCode), hostedRepositoriesResponse.getStatusLine().getReasonPhrase());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.error("Unable to create client to test remote nxrm instance", (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private void validateNexusCompatibility(String username, String password, boolean useTrustStore, URI base) {
        if (useTrustStore && !this.certificateExistsInTrustStore(base)) {
            this.log.debug("Unable to find the certificate in the internal trust store");
            throw new WebApplicationMessageException(Response.Status.NOT_IMPLEMENTED, "Unable to find the certificate in the internal trust store");
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient client = this.targetInstanceConnector.createHttpClient(username, password, useTrustStore);){
                String version = this.applicationVersion.getVersion();
                HttpGet validateCompatibilityRequest = new HttpGet(base.resolve("service/rest/internal/ui/replication/validate-compatibility?version=" + version));
                CloseableHttpResponse validateCompatibilityResponse = client.execute((HttpUriRequest)validateCompatibilityRequest);
                int validateCompatibilityStatusCode = validateCompatibilityResponse.getStatusLine().getStatusCode();
                if (validateCompatibilityStatusCode != 204) {
                    String compatibilityErrorMessage = EntityUtils.toString((HttpEntity)validateCompatibilityResponse.getEntity());
                    this.log.debug("Testing replication connection version compatibility failed: " + compatibilityErrorMessage);
                    throw new WebApplicationMessageException(Response.Status.fromStatusCode((int)validateCompatibilityStatusCode), compatibilityErrorMessage);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.error("Unable to create client to test remote nxrm instance", (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private boolean certificateExistsInTrustStore(URI base) {
        ApiCertificate hostCertificate = this.getHostCertificate(base);
        try {
            return this.trustStore.getTrustedCertificates().stream().map(this::convertOrNull).filter(Objects::nonNull).anyMatch(certificate -> certificate.getId().equals(hostCertificate.getId()));
        }
        catch (KeystoreException e) {
            this.log.error("An error occurred accessing the internal trust store.", (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, "An error occurred accessing the trust store.");
        }
    }

    private ApiCertificate getHostCertificate(URI base) {
        String host = base.getHost();
        int port = base.getPort() > 0 ? base.getPort() : 443;
        try {
            Certificate[] certificates = this.certificateRetriever.retrieveCertificates(host, Integer.valueOf(port), null);
            if (certificates == null || certificates.length == 0) {
                throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, "Unable to retrieve certificate from host: " + host);
            }
            return ApiCertificate.convert((Certificate)certificates[0]);
        }
        catch (UnknownHostException unknownHostException) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, "Unknown host " + host);
        }
        catch (Exception e) {
            this.log.debug("Failed to retrieve certificate from host:{} on port:{}", new Object[]{host, port, e});
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    private ApiCertificate convertOrNull(Certificate certificate) {
        try {
            return ApiCertificate.convert((Certificate)certificate);
        }
        catch (IOException | CertificateEncodingException | InvalidNameException e) {
            this.log.info("Failed to convert certificate {}", (Object)certificate, (Object)e);
            return null;
        }
    }
}

